<?php
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version 	1.1.5
 * 
 * Website Header Template
 * Created by CMSMasters
 * 
 */


$cmsmasters_option = kids_get_global_options();


?><!DOCTYPE html>
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 8)]><!-->
<html <?php language_attributes(); ?> class="cmsmasters_html">
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo('charset'); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php esc_url(bloginfo('pingback_url')); ?>" />
<?php wp_head();?>
</head>
<body <?php body_class(); ?>>
	
<!--  Start Page -->
<div id="page" class="<?php cmsmasters_get_page_classes($cmsmasters_option); ?>hfeed site">

<!--  Start Main -->
<div id="main">
<?php 
if (CMSMASTERS_WOOCOMMERCE) {
	echo '<div class="cmsmasters_dynamic_cart_wrap">';
		kids_woocommerce_cart_dropdown($cmsmasters_option); 
	echo '</div>';
}
?>
<!--  Start Header -->
<header id="header">
	<?php 
	cmsmasters_header_top($cmsmasters_option);
	
	
	cmsmasters_header_mid($cmsmasters_option);
	
	
	cmsmasters_header_bot($cmsmasters_option);
	?>
</header>
<!--  Finish Header -->

	
<!--  Start Middle -->
<div id="middle"<?php echo (is_404()) ? ' class="error_page"' : ''; ?>>
<?php 
if (!is_404() && !is_home()) {
	kids_page_heading();
} else {
	echo "<div class=\"headline\">
		<div class=\"headline_outer cmsmasters_headline_disabled\"></div>
	</div>";
}


list($cmsmasters_layout, $cmsmasters_page_scheme) = kids_theme_page_layout_scheme();


$cmsmasters_project_title = get_post_meta(get_the_ID(), 'cmsmasters_project_title', true);


$cmsmasters_profile_title = get_post_meta(get_the_ID(), 'cmsmasters_profile_title', true);

$cmsmasters_profile_subtitle = get_post_meta(get_the_ID(), 'cmsmasters_profile_subtitle', true);


echo '<div class="middle_inner' . (($cmsmasters_page_scheme != 'default') ? ' cmsmasters_color_scheme_' . $cmsmasters_page_scheme : '') . '">';
	
	if (is_singular('profile') && $cmsmasters_profile_title == 'true') {		
		echo '<header class="cmsmasters_profile_header entry-header">'; 
			kids_profile_title_nolink(get_the_ID(), 'h1', $cmsmasters_profile_subtitle, 'h3');
		echo '</header>';
	}
	
	if (is_singular('project') && $cmsmasters_project_title == 'true') {
		echo '<header class="cmsmasters_project_header entry-header">';
			kids_project_title_nolink(get_the_ID(), 'h1');
		echo '</header>';
	}
	
	echo '<div class="content_wrap ' . $cmsmasters_layout . 
	((is_singular('project')) ? ' project_page' : '') . 
	((is_singular('profile')) ? ' profile_page' : '') . 
	((CMSMASTERS_WOOCOMMERCE && (
		is_woocommerce() || 
		is_cart() || 
		is_checkout() || 
		is_checkout_pay_page() || 
		is_account_page() || 
		is_order_received_page() || 
		is_add_payment_method_page()
	)) ? ' cmsmasters_woo' : '') . 
	'">' . "\n\n";

