<?php
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version		1.1.5
 * 
 * Main Theme Functions File
 * Created by CMSMasters
 * 
 */



/*** START EDIT THEME PARAMETERS HERE ***/

// Theme Settings System Fonts List
if (!function_exists('kids_system_fonts_list')) {
	function kids_system_fonts_list() {
		$fonts = array( 
			"Arial, Helvetica, 'Nimbus Sans L', sans-serif" => 'Arial', 
			"Calibri, 'AppleGothic', 'MgOpen Modata', sans-serif" => 'Calibri', 
			"'Trebuchet MS', Helvetica, Garuda, sans-serif" => 'Trebuchet MS', 
			"'Comic Sans MS', Monaco, 'TSCu_Comic', cursive" => 'Comic Sans MS', 
			"Georgia, Times, 'Century Schoolbook L', serif" => 'Georgia', 
			"Verdana, Geneva, 'DejaVu Sans', sans-serif" => 'Verdana', 
			"Tahoma, Geneva, Kalimati, sans-serif" => 'Tahoma', 
			"'Lucida Sans Unicode', 'Lucida Grande', Garuda, sans-serif" => 'Lucida Sans', 
			"'Times New Roman', Times, 'Nimbus Roman No9 L', serif" => 'Times New Roman', 
			"'Courier New', Courier, 'Nimbus Mono L', monospace" => 'Courier New', 
		);
		
		
		return $fonts;
	}
}



// Theme Settings Google Fonts List
if (!function_exists('cmsmasters_google_fonts_list')) {
	function cmsmasters_google_fonts_list() {
		$fonts = array( 
			'' => esc_html__('None', 'kids'), 
			'Titillium+Web:300,300italic,400,400italic,600,600italic,700,700italic' => 'Titillium Web', 
			'Roboto:300,300italic,400,400italic,500,500italic,700,700italic' => 'Roboto', 
			'Roboto+Condensed:400,400italic,700,700italic' => 'Roboto Condensed', 
			'Open+Sans:300,300italic,400,400italic,700,700italic' => 'Open Sans', 
			'Open+Sans+Condensed:300,300italic,700' => 'Open Sans Condensed', 
			'Droid+Sans:400,700' => 'Droid Sans', 
			'Droid+Serif:400,400italic,700,700italic' => 'Droid Serif', 
			'PT+Sans:400,400italic,700,700italic' => 'PT Sans', 
			'PT+Sans+Caption:400,700' => 'PT Sans Caption', 
			'PT+Sans+Narrow:400,700' => 'PT Sans Narrow', 
			'PT+Serif:400,400italic,700,700italic' => 'PT Serif', 
			'Ubuntu:400,400italic,700,700italic' => 'Ubuntu', 
			'Ubuntu+Condensed' => 'Ubuntu Condensed', 
			'Headland+One' => 'Headland One', 
			'Source+Sans+Pro:300,300italic,400,400italic,700,700italic' => 'Source Sans Pro', 
			'Lato:400,400italic,700,700italic' => 'Lato', 
			'Cuprum:400,400italic,700,700italic' => 'Cuprum', 
			'Oswald:300,400,700' => 'Oswald', 
			'Yanone+Kaffeesatz:300,400,700' => 'Yanone Kaffeesatz', 
			'Lobster' => 'Lobster', 
			'Lobster+Two:400,400italic,700,700italic' => 'Lobster Two', 
			'Londrina+Solid' => 'Londrina Solid', 
			'Questrial' => 'Questrial', 
			'Raleway:300,400,500,600,700' => 'Raleway', 
			'Dosis:300,400,500,700' => 'Dosis', 
			'Cutive+Mono' => 'Cutive Mono', 
			'Quicksand:300,400,700' => 'Quicksand', 
			'Montserrat:400,700' => 'Montserrat', 
			'Cookie' => 'Cookie', 
		);
		
		
		return $fonts;
	}
}



// Theme Settings Text Transforms List
if (!function_exists('kids_text_transform_list')) {
	function kids_text_transform_list() {
		$list = array( 
			'none' => esc_html__('none', 'kids'), 
			'uppercase' => esc_html__('uppercase', 'kids'), 
			'lowercase' => esc_html__('lowercase', 'kids'), 
			'capitalize' => esc_html__('capitalize', 'kids'), 
		);
		
		
		return $list;
	}
}



// Theme Settings Text Decorations List
if (!function_exists('kids_text_decoration_list')) {
	function kids_text_decoration_list() {
		$list = array( 
			'none' => esc_html__('none', 'kids'), 
			'underline' => esc_html__('underline', 'kids'), 
			'overline' => esc_html__('overline', 'kids'), 
			'line-through' => esc_html__('line-through', 'kids'), 
		);
		
		
		return $list;
	}
}



// Theme Settings Custom Color Schemes
if (!function_exists('kids_custom_color_schemes_list')) {
	function kids_custom_color_schemes_list() {
		$list = array( 
			'first' => esc_html__('Custom 1', 'kids'), 
			'second' => esc_html__('Custom 2', 'kids'), 
			'third' => esc_html__('Custom 3', 'kids') 
		);
		
		
		return $list;
	}
}
/*** STOP EDIT THEME PARAMETERS HERE ***/



// Require Files Function
if (!function_exists('kids_locate_template')) {
	function kids_locate_template($template_names, $require_once = true, $load = true) {
		$located = '';
		
		
		foreach ((array) $template_names as $template_name) {
			if (!$template_name) {
				continue;
			}
			
			
			if (file_exists(get_stylesheet_directory() . '/' . $template_name)) {
				$located = get_stylesheet_directory() . '/' . $template_name;
				
				
				break;
			} elseif (file_exists(get_template_directory() . '/' . $template_name)) {
				$located = get_template_directory() . '/' . $template_name;
				
				
				break;
			}
		}
		
		
		if ($load && $located != '') {
			if ($require_once) {
				require_once($located);
			} else {
				require($located);
			}
		}
		
		
		return $located;
	}
}



// Theme Plugin Support Constants
if (class_exists('Cmsmasters_Content_Composer')) {
	define('CMSMASTERS_CONTENT_COMPOSER', true);
} else {
	define('CMSMASTERS_CONTENT_COMPOSER', false);
}

if (class_exists('woocommerce')) {
	define('CMSMASTERS_WOOCOMMERCE', true);
} else {
	define('CMSMASTERS_WOOCOMMERCE', false);
}

if (class_exists('Tribe__Events__Main')) {
	define('CMSMASTERS_EVENTS_CALENDAR', true);
} else {
	define('CMSMASTERS_EVENTS_CALENDAR', false);
}

if (class_exists('PayPalDonations')) {
	define('CMSMASTERS_PAYPALDONATIONS', false);
} else {
	define('CMSMASTERS_PAYPALDONATIONS', false);
}

if (class_exists('Cmsmasters_Donations')) {
	define('CMSMASTERS_DONATIONS', false);
} else {
	define('CMSMASTERS_DONATIONS', false);
}

if (function_exists('timetable_events_init')) {
	define('CMSMASTERS_TIMETABLE', true);
} else {
	define('CMSMASTERS_TIMETABLE', false);
}

// Change FS Method
if (!defined('FS_METHOD')) {
	define('FS_METHOD', 'direct');
}


// CMSMasters Importer Compatibility
define('CMSMASTERS_IMPORTER', true);

// Theme Colored Categories Constant
define('CMSMASTERS_COLORED_CATEGORIES', true);

// Theme Projects Compatible
define('CMSMASTERS_PROJECT_COMPATIBLE', true);

// Theme Profiles Compatible
define('CMSMASTERS_PROFILE_COMPATIBLE', true);

// Developer Mode Constant
define('CMSMASTERS_DEVELOPER_MODE', false);



// Theme Image Thumbnails Size
if (!function_exists('cmsmasters_image_thumbnail_list')) {
	function cmsmasters_image_thumbnail_list() {
		$list = array( 
			'cmsmasters-small-thumb' => array( 
				'width' => 		70, 
				'height' => 	70, 
				'crop' => 		true 
			), 
			'cmsmasters-square-thumb' => array( 
				'width' => 		300, 
				'height' => 	300, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Square', 'kids') 
			), 
			'cmsmasters-blog-masonry-thumb' => array( 
				'width' => 		580, 
				'height' => 	390, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Masonry Blog', 'kids') 
			), 
			'cmsmasters-blog-puzzle' => array( 
				'width' => 		400, 
				'height' => 	400, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Blog Puzzle', 'kids') 
			), 
			'cmsmasters-project-thumb' => array( 
				'width' => 		580, 
				'height' => 	375, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Project', 'kids') 
			), 
			'cmsmasters-project-masonry-thumb' => array( 
				'width' => 		580, 
				'height' => 	9999, 
				'title' => 		esc_attr__('Masonry Project', 'kids') 
			), 
			'post-thumbnail' => array( 
				'width' => 		860, 
				'height' => 	400, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Featured', 'kids') 
			), 
			'cmsmasters-masonry-thumb' => array( 
				'width' => 		860, 
				'height' => 	9999, 
				'title' => 		esc_attr__('Masonry', 'kids') 
			), 
			'cmsmasters-full-thumb' => array( 
				'width' => 		1160, 
				'height' => 	540, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Full', 'kids') 
			), 
			'cmsmasters-project-full-thumb' => array( 
				'width' => 		1160, 
				'height' => 	620, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Project Full', 'kids') 
			), 
			'cmsmasters-full-masonry-thumb' => array( 
				'width' => 		1160, 
				'height' => 	9999, 
				'title' => 		esc_attr__('Masonry Full', 'kids') 
			) 
		);
		
		
		if (CMSMASTERS_EVENTS_CALENDAR) {
			$list['cmsmasters-event-thumb'] = array( 
				'width' => 		580, 
				'height' => 	380, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Event', 'kids') 
			);
		}
		
		
		return $list;
	}
}



// Theme Settings All Color Schemes List
if (!function_exists('kids_all_color_schemes_list')) {
	function kids_all_color_schemes_list() {
		$list = array( 
			'default' => 		esc_html__('Default', 'kids'), 
			'header' => 		esc_html__('Header', 'kids'), 
			'navigation' => 	esc_html__('Navigation', 'kids'), 
			'header_top' => 	esc_html__('Header Top', 'kids'), 
			'footer' => 		esc_html__('Footer', 'kids') 
		);
		
		
		$out = array_merge($list, kids_custom_color_schemes_list());
		
		
		return apply_filters('cmsmasters_all_color_schemes_list_filter', $out);
	}
}



// Theme Settings Color Schemes Default Colors
if (!function_exists('kids_color_schemes_defaults')) {
	function kids_color_schemes_defaults() {
		$list = array( 
			'default' => array( // content default color scheme
				'color' => 		'#656f73', 
				'link' => 		'#a6a6a6', 
				'hover' => 		'#454a4c', 
				'heading' => 	'#434a54', 
				'bg' => 		'#ffffff', 
				'alternate' => 	'#efefef', 
				'border' => 	'#efefef', 
				'secondary' =>	'#fb6b47'
			), 
			'header' => array( // Header color scheme
				'mid_color' => 		'#656f73', 
				'mid_link' => 		'#a671be', 
				'mid_hover' => 		'#a6a6a6', 
				'mid_bg' => 		'#ffffff', 
				'mid_bg_scroll' => 	'#ffffff', 
				'mid_border' => 	'#f2f2f2', 
				'bot_color' => 		'#656f73', 
				'bot_link' => 		'#a6a6a6', 
				'bot_hover' => 		'#6e767a', 
				'bot_bg' => 		'#ffffff', 
				'bot_bg_scroll' => 	'#ffffff', 
				'bot_border' => 	'#f2f2f2' 
			), 
			'navigation' => array( // Navigation color scheme
				'title_link' => 			'#fb6b47', 
				'title_link_hover' => 		'#a6a6a6', 
				'title_link_current' => 	'#ffffff', 
				'title_link_subtitle' => 	'#656f73', 
				'title_link_bg' => 			'rgba(255,255,255,0)', 
				'title_link_bg_hover' => 	'rgba(255,255,255,0)', 
				'title_link_bg_current' => 	'#fb6b47', 
				'title_link_border' => 		'#ffffff', 
				'dropdown_text' => 			'#8b8a8a', 
				'dropdown_bg' => 			'#f4f4f4', 
				'dropdown_border' => 		'#f2f2f2', 
				'dropdown_link' => 			'#434a54', 
				'dropdown_link_hover' => 	'#fb6b47', 
				'dropdown_link_subtitle' => '#8b8a8a', 
				'dropdown_link_highlight' => '#ffffff', 
				'dropdown_link_border' => 	'#f4f4f4' 
			), 
			'header_top' => array( // Header Top color scheme
				'color' => 					'#ffffff', 
				'link' => 					'#ffffff', 
				'hover' => 					'#abcd52', 
				'bg' => 					'#484f7f', 
				'border' => 				'#f4f4f4', 
				'title_link' => 			'#ffffff', 
				'title_link_hover' => 		'#abcd52', 
				'title_link_bg' => 			'#484f7f', 
				'title_link_bg_hover' => 	'#484f7f', 
				'title_link_border' => 		'#484f7f', 
				'dropdown_bg' => 			'#f4f4f4', 
				'dropdown_border' => 		'#f4f4f4', 
				'dropdown_link' => 			'#434a54', 
				'dropdown_link_hover' => 	'#fb6b47', 
				'dropdown_link_highlight' => '#ffffff', 
				'dropdown_link_border' => 	'#f4f4f4' 
			), 
			'footer' => array( // Footer color scheme
				'color' => 		'#656f73', 
				'link' => 		'#434a54', 
				'hover' => 		'#abcd52', 
				'heading' => 	'#ffffff', 
				'bg' => 		'#ffffff', 
				'alternate' => 	'#634c7a', 
				'border' => 	'#f4f4f4', 
				'secondary' =>	'#ffffff' 
			), 
			'first' => array( // custom color scheme 1
				'color' => 		'#8b8a8a', 
				'link' => 		'#484f7f', 
				'hover' => 		'#fb6b47', 
				'heading' => 	'#ffffff', 
				'bg' => 		'rgba(255,255,255,0.8)', 
				'alternate' => 	'#65517a', 
				'border' => 	'#f2f2f2', 
				'secondary' =>	'#a6a6a6'
			), 
			'second' => array( // custom color scheme 2
				'color' => 		'#ffffff', 
				'link' => 		'#ffffff', 
				'hover' => 		'#86abb9', 
				'heading' => 	'#ffffff', 
				'bg' => 		'#ffffff', 
				'alternate' => 	'#60425f', 
				'border' => 	'#e0eef0', 
				'secondary' =>	'#fe677a'
			), 
			'third' => array( // custom color scheme 3
				'color' => 		'#8b8a8a', 
				'link' => 		'#207b9e', 
				'hover' => 		'#f96c7e', 
				'heading' => 	'#ffffff', 
				'bg' => 		'#ffffff', 
				'alternate' => 	'#60425f', 
				'border' => 	'#e0eef0', 
				'secondary' =>	'#ffffff'
			) 
		);
		
		
		return $list;
	}
}



// CMSMasters Framework Directories Constants
define('CMSMASTERS_FRAMEWORK', 'framework');
define('CMSMASTERS_ADMIN', CMSMASTERS_FRAMEWORK . '/admin');
define('CMSMASTERS_SETTINGS', CMSMASTERS_ADMIN . '/settings');
define('CMSMASTERS_OPTIONS', CMSMASTERS_ADMIN . '/options');
define('CMSMASTERS_ADMIN_INC', CMSMASTERS_ADMIN . '/inc');
define('CMSMASTERS_CLASS', CMSMASTERS_FRAMEWORK . '/class');
define('CMSMASTERS_FUNCTION', CMSMASTERS_FRAMEWORK . '/function');
define('CMSMASTERS_COMPOSER', 'cmsmasters-c-c');
define('CMSMASTERS_DEMO_FILES_PATH', get_template_directory() . '/framework/admin/inc/demo-content/');


// Load Framework Parts
kids_locate_template(CMSMASTERS_CLASS . '/Browser.php', true);

if (class_exists('Cmsmasters_Theme_Importer')) {
	require_once(CMSMASTERS_ADMIN_INC . '/demo-content-importer.php');
}

kids_locate_template(CMSMASTERS_ADMIN_INC . '/config-functions.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/theme-functions.php', true);

kids_locate_template(CMSMASTERS_SETTINGS . '/cmsmasters-theme-settings.php', true);

kids_locate_template(CMSMASTERS_OPTIONS . '/cmsmasters-theme-options.php', true);

kids_locate_template(CMSMASTERS_ADMIN_INC . '/admin-scripts.php', true);

kids_locate_template(CMSMASTERS_ADMIN_INC . '/plugin-activator.php', true);

kids_locate_template(CMSMASTERS_CLASS . '/widgets.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/breadcrumbs.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/likes.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/pagination.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/single-comment.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/theme-fonts.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/theme-colors-primary.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/theme-colors-secondary.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/template-functions.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/template-functions-post.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/template-functions-project.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/template-functions-profile.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/template-functions-shortcodes.php', true);

kids_locate_template(CMSMASTERS_FUNCTION . '/template-functions-widgets.php', true);


$cmsmasters_wp_version = get_bloginfo('version');

if (version_compare($cmsmasters_wp_version, '5', '>=') || function_exists('is_gutenberg_page')) {
	require_once(get_template_directory() . '/gutenberg/cmsmasters-module-functions.php');
}


// Theme Colored Categories Functions
if (CMSMASTERS_COLORED_CATEGORIES) {
	kids_locate_template(CMSMASTERS_FUNCTION . '/theme-colored-categories.php', true);
}


if (class_exists('Cmsmasters_Content_Composer')) {
	kids_locate_template(CMSMASTERS_COMPOSER . '/filters/cmsmasters-c-c-atts-filters.php', true);
}


// CMSMASTERS Donations functions
if (CMSMASTERS_DONATIONS) {
	kids_locate_template('cmsmasters-donations/function/template-functions-donation.php', true);
}

// Woocommerce functions
if (CMSMASTERS_WOOCOMMERCE) {
	kids_locate_template('woocommerce/cmsmasters-woo-functions.php', true);
}

// Events functions
if (CMSMASTERS_EVENTS_CALENDAR) {
	kids_locate_template('tribe-events/cmsmasters-events-functions.php', true);
}



// Load Theme Local File
if (!function_exists('kids_load_theme_textdomain')) {
	function kids_load_theme_textdomain() {
		load_theme_textdomain('kids', get_template_directory() . '/' . CMSMASTERS_FRAMEWORK . '/languages');
	}
}

// Load Theme Local File Action
if (!has_action('after_setup_theme', 'kids_load_theme_textdomain')) {
	add_action('after_setup_theme', 'kids_load_theme_textdomain');
}



// Framework Activation & Data Import
if (!function_exists('kids_theme_activation')) {
	function kids_theme_activation() {
		if (get_option('cmsmasters_active_theme') != 'kids') {
			add_option('cmsmasters_active_theme', 'kids', '', 'yes');
			
			
			kids_add_global_options();
			
			
			kids_add_global_icons();
			
			
			wp_redirect(esc_url(admin_url('admin.php?page=cmsmasters-settings&upgraded=true')));
		}
	}
}

add_action('after_switch_theme', 'kids_theme_activation');



// Framework Deactivation
if (!function_exists('kids_theme_deactivation')) {
	function kids_theme_deactivation() {
		delete_option('cmsmasters_active_theme');
	}
}

// Framework Deactivation Action
if (!has_action('switch_theme', 'kids_theme_deactivation')) {
	add_action('switch_theme', 'kids_theme_deactivation');
}



// Plugin Activation Regenerate Styles
if (!function_exists('kids_plugin_activation')) {
	function kids_plugin_activation($plugin, $network_activation) {
		update_option('cmsmasters_plugin_activation', 'true');
		
		
		if ($plugin == 'classic-editor/classic-editor.php') {
			update_option('classic-editor-replace', 'no-replace');
		}
	}
}

add_action('activated_plugin', 'kids_plugin_activation', 10, 2);


if (!function_exists('kids_plugin_activation_regenerate')) {
	function kids_plugin_activation_regenerate() {
		if (!get_option('cmsmasters_plugin_activation')) {
			add_option('cmsmasters_plugin_activation', 'false');
		}
		
		if (get_option('cmsmasters_plugin_activation') != 'false') {
			kids_regenerate_styles();
			
			kids_add_global_options();
			
			kids_add_global_icons();
			
			update_option('cmsmasters_plugin_activation', 'false');
		}
	}
}

add_action('init', 'kids_plugin_activation_regenerate');


function kids_run_reinit_import_options($post_id, $key, $value) {
	if (!get_post_meta($post_id, 'cmsmasters_heading', true)) {
		$custom_post_meta_fields = kids_get_custom_all_meta_fields();
		
		
		foreach ($custom_post_meta_fields as $field) {
			if ( 
				$field['type'] != 'tabs' && 
				$field['type'] != 'tab_start' && 
				$field['type'] != 'tab_finish' && 
				$field['type'] != 'content_start' && 
				$field['type'] != 'content_finish' 
			) {
				update_post_meta($post_id, $field['id'], $field['std']);
			}
		}
	}


	if ($key === 'cmsmasters_composer_show' && $value === 'true') {
		update_post_meta($post_id, 'cmsmasters_gutenberg_show', 'true');
	}
}

add_action('import_post_meta', 'kids_run_reinit_import_options', 10, 3);

