<?php
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version		1.1.5
 * 
 * Posts Slider Audio Post Format Template
 * Created by CMSMasters
 * 
 */


$cmsmasters_metadata = explode(',', $cmsmasters_post_metadata);

$title = in_array('title', $cmsmasters_metadata) ? true : false;
$excerpt = (in_array('excerpt', $cmsmasters_metadata) && kids_slider_post_check_exc_cont('post')) ? true : false;
$date = in_array('date', $cmsmasters_metadata) ? true : false;
$categories = (get_the_category() && (in_array('categories', $cmsmasters_metadata))) ? true : false;
$author = in_array('author', $cmsmasters_metadata) ? true : false;
$comments = (comments_open() && (in_array('comments', $cmsmasters_metadata))) ? true : false;
$likes = in_array('likes', $cmsmasters_metadata) ? true : false;
$more = in_array('more', $cmsmasters_metadata) ? true : false;

?>

<!-- Start Audio Article -->

<article id="post-<?php the_ID(); ?>" <?php post_class('cmsmasters_slider_post'); ?>>
	<?php kids_post_color(get_the_ID(), get_post_format(), 'post_slider'); ?>
	
	<div class="cmsmasters_slider_post_outer">
	<?php
		echo '<div class="cmsmasters_slider_post_date_img_wrap">';
		
			kids_thumb_rollover(get_the_ID(), 'cmsmasters-project-thumb', false, false, false, false, false, false, false, false, true, false, false);
			
			$date ? kids_get_slider_post_date('post') : '';
		
		echo '</div>';
		
		
		if ($title || $author || $categories || $excerpt || $likes || $comments || $more) {
			echo '<div class="cmsmasters_slider_post_inner">';
				
				$title ? kids_slider_post_heading(get_the_ID(), 'post', 'h2') : '';
				
				$excerpt ? kids_slider_post_exc_cont('post') : '';
				
				$more ? kids_slider_post_more(get_the_ID()) : '';
				
				if ($likes || $comments || $author || $categories) {
					echo '<footer class="cmsmasters_slider_post_footer entry-meta">';
					
						if ($author || $categories) {
							echo '<div class="cmsmasters_slider_post_cont_info entry-meta">';
								
								$author ? kids_get_slider_post_author('post') : '';
								
								$categories ? kids_get_slider_post_category(get_the_ID(), 'category', 'post') : '';
								
							echo '</div>';
						}
						
						
						if ($likes || $comments) {
							echo '<div class="cmsmasters_slider_post_meta_info entry-meta">';
								
								$comments ? kids_get_slider_post_comments('post') : '';
								
								$likes ? kids_slider_post_like('post') : '';
								
							echo '</div>';
						}
					
					echo '</footer>';
				}
				
			echo '</div>';
		}
	?>
	</div>
</article>
<!-- Finish Audio Article -->

