<?php
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version		1.1.5
 * 
 * Blog Post Audio Post Format Template
 * Created by CMSMasters
 * 
 */


$cmsmasters_option = kids_get_global_options();


$cmsmasters_post_title = get_post_meta(get_the_ID(), 'cmsmasters_post_title', true);

$cmsmasters_post_audio_links = get_post_meta(get_the_ID(), 'cmsmasters_post_audio_links', true);

?>

<!-- Start Audio Article -->

<article id="post-<?php the_ID(); ?>" <?php post_class('cmsmasters_open_post'); ?>>
	<?php kids_post_color(get_the_ID(), get_post_format(), 'post');
	
	if (!post_password_required() && !empty($cmsmasters_post_audio_links) && sizeof($cmsmasters_post_audio_links) > 0) {
		$attrs = array(
			'preload' => 'none'
		);
		
		
		foreach ($cmsmasters_post_audio_links as $cmsmasters_post_audio_link_url) {
			$attrs[substr(strrchr($cmsmasters_post_audio_link_url, '.'), 1)] = $cmsmasters_post_audio_link_url;
		}
		
		
		echo '<div class="cmsmasters_audio">' . 
			wp_audio_shortcode($attrs) . 
		'</div>';
	}
	
	kids_get_post_date('post');
	
	if (
		$cmsmasters_option['kids' . '_blog_post_comment'] || 
		$cmsmasters_option['kids' . '_blog_post_like'] || 
		$cmsmasters_option['kids' . '_blog_post_tag'] || 
		$cmsmasters_option['kids' . '_blog_post_date'] || 
		$cmsmasters_option['kids' . '_blog_post_author'] || 
		$cmsmasters_option['kids' . '_blog_post_cat'] 
	) {
		echo '<div class="cmsmasters_post_cont_info entry-meta">';
			
			if ($cmsmasters_post_title == 'true') {
				kids_post_title_nolink(get_the_ID(), 'h2');
			}
			
			if (
				$cmsmasters_option['kids' . '_blog_post_tag'] || 
				$cmsmasters_option['kids' . '_blog_post_author'] || 
				$cmsmasters_option['kids' . '_blog_post_cat'] 
			) {
				echo '<div class="cmsmasters_post_cont_info_left entry-meta">';
				
					kids_get_post_author('post');
			
					kids_get_post_category(get_the_ID(), 'category', 'post');
				
					kids_get_post_tags();
				
				echo '</div>';
			}
			
			if (
				$cmsmasters_option['kids' . '_blog_post_comment'] || 
				$cmsmasters_option['kids' . '_blog_post_like']
			) {
				echo '<div class="cmsmasters_post_cont_info_right entry-meta">';
				
					kids_get_post_likes('post');
				
					kids_get_post_comments('post');
					
				echo '</div>';
			}
			
		echo '</div>';
	}
	
	
	if (get_the_content() != '') {
		echo '<div class="cmsmasters_post_content entry-content">';
			
			the_content();
			
			
			wp_link_pages(array( 
				'before' => '<div class="subpage_nav" role="navigation">' . '<strong>' . esc_html__('Pages', 'kids') . ':</strong>', 
				'after' => '</div>', 
				'link_before' => '<span>', 
				'link_after' => '</span>' 
			));
			
		echo '</div>';
	}
	?>
</article>
<!-- Finish Audio Article -->

