<?php
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version		1.1.5
 * 
 * Blog Page Masonry Image Post Format Template
 * Created by CMSMasters
 * 
 */


$cmsmasters_post_metadata = explode(',', $cmsmasters_metadata);


$date = (in_array('date', $cmsmasters_post_metadata) || is_home()) ? true : false;
$categories = (get_the_category() && (in_array('categories', $cmsmasters_post_metadata) || is_home())) ? true : false;
$author = (in_array('author', $cmsmasters_post_metadata) || is_home()) ? true : false;
$comments = (comments_open() && (in_array('comments', $cmsmasters_post_metadata) || is_home())) ? true : false;
$likes = (in_array('likes', $cmsmasters_post_metadata) || is_home()) ? true : false;
$more = (in_array('more', $cmsmasters_post_metadata) || is_home()) ? true : false;


$cmsmasters_post_image_link = get_post_meta(get_the_ID(), 'cmsmasters_post_image_link', true);


$post_sort_categs = get_the_terms(0, 'category');

if ($post_sort_categs != '') {
	$post_categs = '';
	
	foreach ($post_sort_categs as $post_sort_categ) {
		$post_categs .= ' ' . $post_sort_categ->slug;
	}
	
	$post_categs = ltrim($post_categs, ' ');
}

?>

<!-- Start Image Article -->

<article id="post-<?php the_ID(); ?>" <?php post_class('cmsmasters_post_masonry'); ?> data-category="<?php echo esc_attr($post_categs); ?>">
	<div class="cmsmasters_post_cont">
		<?php kids_post_color(get_the_ID(), get_post_format(), 'masonry'); ?>
		
		<?php 
		if (!post_password_required() && $cmsmasters_post_image_link != '') {
			kids_thumb(get_the_ID(), 'cmsmasters-masonry-thumb', false, 'img_' . get_the_ID(), true, true, true, true, $cmsmasters_post_image_link);
		} elseif (!post_password_required() && has_post_thumbnail()) {
			kids_thumb(get_the_ID(), 'cmsmasters-masonry-thumb', false, 'img_' . get_the_ID(), true, true, true, true, false);
		}
		
		
		echo '<div class="cmsmasters_post_cont_info_wrap">';
		
			$date ? kids_get_post_date('page', 'masonry') : '';
			
			kids_post_heading(get_the_ID(), 'h2');
			
			
			kids_post_exc_cont();
			
			
			$more ? kids_post_more(get_the_ID()) : '';
			
			
			if ($likes || $comments || $author || $categories) {
				echo '<footer class="cmsmasters_post_footer entry-meta">';
					
					if ($author || $categories) {
						echo '<div class="cmsmasters_post_cont_info_left entry-meta">';
							
							$author ? kids_get_post_author('page') : '';
							
							$categories ? kids_get_post_category(get_the_ID(), 'category', 'page') : '';
							
						echo '</div>';
					}
					
					if ($likes || $comments) {
						echo '<div class="cmsmasters_post_cont_info_right entry-meta">';
							
							$comments ? kids_get_post_comments('page') : '';
							
							$likes ? kids_get_post_likes('page') : '';
							
						echo '</div>';
					}
					
				echo '</footer>';
			}
		
		echo '</div>';
	?>
	</div>
</article>
<!-- Finish Image Article -->

