<?php
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version 	1.1.4
 * 
 * Theme Secondary Color Schemes Rules
 * Created by CMSMasters
 * 
 */


function kids_theme_colors_secondary() {
	$cmsmasters_option = kids_get_global_options();
	
	
	$cmsmasters_color_schemes = cmsmasters_color_schemes_list();
	
	
	$custom_css = "/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version 	1.1.4
 * 
 * Theme Secondary Color Schemes Rules
 * Created by CMSMasters
 * 
 */

";
	
	
	foreach ($cmsmasters_color_schemes as $scheme => $title) {
		$rule = (($scheme != 'default') ? "html .cmsmasters_color_scheme_{$scheme} " : '');
		
		
		if (CMSMASTERS_DONATIONS) {
			$custom_css .= "
/***************** Start {$title} CMSMASTERS Donations Color Scheme Rules ******************/

	/* Start Main Content Font Color */
	{$rule}.cmsmasters_donations_color {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	/* Finish Main Content Font Color */
	
	
	/* Start Primary Color */
	{$rule}.cmsmasters_donations_link {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	/* Finish Primary Color */
	
	
	/* Start Highlight Color */
	{$rule}.cmsmasters_donations_hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}
	/* Finish Highlight Color */
	
	
	/* Start Headings Color */
	{$rule}.cmsmasters_donations_heading {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_heading']) . "
	}
	/* Finish Headings Color */
	
	
	/* Start Main Background Color */
	{$rule}.cmsmasters_donations_bg {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	/* Finish Main Background Color */
	
	
	/* Start Alternate Background Color */
	{$rule}.cmsmasters_donations_alternate {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . "
	}
	/* Finish Alternate Background Color */
	
	
	/* Start Borders Color */
	{$rule}.cmsmasters_donations_border {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_border']) . "
	}
	/* Finish Borders Color */

/***************** Finish {$title} CMSMASTERS Donations Color Scheme Rules ******************/


";
		}
		
		
		if (CMSMASTERS_TIMETABLE) {
			$custom_css .= "
/***************** Start {$title} CMSMASTERS Donations Color Scheme Rules ******************/

	/* Start Main Content Font Color */
	/* Finish Main Content Font Color */
	
	
	/* Start Primary Color */
	/* Finish Primary Color */
	
	
	/* Start Highlight Color */
		{$rule}.tt_booking a.tt_btn {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
		}
	/* Finish Highlight Color */
	
	
	/* Start Headings Color */
	{$rule}.tt_upcoming_events_wrapper .tt_upcoming_event_controls > a {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_heading']) . "
	}
	/* Finish Headings Color */
	
	
	/* Start Main Background Color */
	{$rule}.tt_upcoming_events_wrapper .tt_upcoming_event_controls > a:hover,
	{$rule}.tt_booking a.tt_btn, 
	{$rule}.tt_booking a.tt_btn:hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}

	{$rule}.tt_booking .tt_booking_message_wrapper {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	/* Finish Main Background Color */
	
	
	/* Start Alternate Background Color */
	{$rule}.cmsmasters_tt_event_details_title, 
	{$rule}.tt_upcoming_events_wrapper .tt_upcoming_event_controls > a, 
	{$rule}.cmsmasters_tt_event_hours_title,
	{$rule}ul.tt_items_list li {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . "
	}
	/* Finish Alternate Background Color */
	
	
	/* Start Borders Color */
	/* Finish Borders Color */
	
	
	
	/* Start Secondary Color */
	{$rule}.tt_booking a.tt_btn:hover, 
	{$rule}.tt_upcoming_events_wrapper .tt_upcoming_event_controls > a:hover {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	/* Finish Secondary Color */
	
/***************** Finish {$title} CMSMASTERS Donations Color Scheme Rules ******************/


";
		}
		
		
		if (CMSMASTERS_WOOCOMMERCE) {
			$custom_css .= "
/***************** Start {$title} WooCommerce Color Scheme Rules ******************/

	/* Start Main Content Font Color */
	{$rule}#shipping_method li label, 
	{$rule}.widget_price_filter .price_slider_amount .price_label, 
	{$rule}.widget > .product_list_widget .amount, 
	{$rule}.shop_table.my_account_orders tbody tr td, 
	{$rule}.shop_table.customer_details td, 
	{$rule}ul.order_details strong, 
	{$rule}.shop_table.order_details tfoot tr td, 
	{$rule}.shop_table.order_details .product-name strong, 
	{$rule}.woocommerce input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]), 
	{$rule}.woocommerce-checkout .payment_methods label, 
	{$rule}.select2-container .select2-choice, 
	{$rule}.shop_table .amount, 
	{$rule}.shop_attributes th, 
	{$rule}.woocommerce select, 
	{$rule}.checkout .product-quantity, 
	{$rule}.woocommerce-message, 
	{$rule}.woocommerce-info, 
	{$rule}.woocommerce-error, 
	{$rule}.woocommerce-error li, 
	{$rule}.select2-container--default .select2-selection--single .select2-selection__rendered, 
	{$rule}.select2-container.select2-drop-above .select2-choice, 
	{$rule}.select2-container.select2-container-active .select2-choice, 
	{$rule}.select2-container.select2-container-active.select2-drop-above .select2-choice,
	{$rule}.cmsmasters_woo_wrap_result .woocommerce-result-count,  
	{$rule}.select2-drop.select2-drop-active, 
	{$rule}.select2-drop.select2-drop-above.select2-drop-active {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}.woocommerce input::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}.woocommerce input:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}.woocommerce textarea:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}.woocommerce textarea::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	
	/* Finish Main Content Font Color */
	
	
	/* Start Primary Color */
	{$rule}.cmsmasters_star_rating .cmsmasters_star_color_wrap, 
	{$rule}.widget_layered_nav ul li a:hover, 
	{$rule}.widget_layered_nav ul li.chosen a, 
	{$rule}.widget_layered_nav_filters ul li a:hover, 
	{$rule}.widget_layered_nav_filters ul li.chosen a, 
	{$rule}.widget_product_categories ul li a:hover, 
	{$rule}.widget_product_categories ul li.current-cat a, 
	{$rule}.woocommerce-store-notice .woocommerce-store-notice__dismiss-link {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.widget_price_filter .ui-slider-handle, 
	{$rule}.woocommerce-store-notice {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.select2-container.select2-container-active .select2-choice, 
	{$rule}.select2-container.select2-container-active.select2-drop-above .select2-choice, 
	{$rule}.select2-drop.select2-drop-active, 
	{$rule}.select2-drop.select2-drop-above.select2-drop-active {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	/* Finish Primary Color */
	
	
	/* Start Highlight Color */
	{$rule}.link_hover_color {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}
	
	{$rule}.shipping-calculator-button,
	{$rule}.cmsmasters_tabs.cmsmasters_woo_tabs .cmsmasters_tabs_list_item a, 
	{$rule}#page .woocommerce .widget_shopping_cart_content .cart_list a, 
	{$rule}.cmsmasters_dynamic_cart .widget_shopping_cart_content .cart_list a, 
	{$rule}.woocommerce-MyAccount-navigation ul > li.is-active, 
	{$rule}.woocommerce-MyAccount-navigation ul > li.is-active a {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}
	
	{$rule}.input-checkbox + label:after, 
	{$rule}.widget_product_tag_cloud a:hover, 
	{$rule}.input-radio + label:after, 
	{$rule}input.shipping_method + label:after, 
	{$rule}.cmsmasters_product .button:hover,
	{$rule}.tribe-bar-views-toggle {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}
	/* Finish Highlight Color */
	
	
	/* Start Headings Color */
	{$rule}.woocommerce-checkout label, 
	{$rule}#page .woocommerce .remove, 
	{$rule}.cmsmasters_product .cmsmasters_product_cat, 
	{$rule}.cmsmasters_product .price, 
	{$rule}.cmsmasters_single_product .price, 
	{$rule}.shop_table, 
	{$rule}.shop_table a:not(.button), 
	{$rule}.cart_totals table, 
	{$rule}.cmsmasters_dynamic_cart .widget_shopping_cart_content .total, 
	{$rule}.cmsmasters_dynamic_cart .widget_shopping_cart_content .total strong, 
	{$rule}.comment-form-rating > label, 
	{$rule}.shop_table.customer_details th, 
	{$rule}.widget_layered_nav ul li, 
	{$rule}.widget_layered_nav ul li a, 
	{$rule}.cmsmasters_dynamic_cart .cmsmasters_dynamic_cart_button, 
	{$rule}.widget_layered_nav_filters ul li, 
	{$rule}.widget_layered_nav_filters ul li a, 
	{$rule}.widget_product_categories ul li, 
	{$rule}.widget_product_categories ul li a, 
	{$rule}#page .widget > .product_list_widget a, 
	{$rule}.widget_shopping_cart .total {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_heading']) . "
	}
	
	{$rule}.out-of-stock, 
	{$rule}ul.order_details li, 
	{$rule}.shop_table thead tr th, 
	{$rule}.stock {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_heading']) . "
	}
	/* Finish Headings Color */
	
	
	/* Start Main Background Color */
	{$rule}.cmsmasters_product .button, 
	{$rule}.woocommerce input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]):focus, 
	{$rule}.shop_table thead, 
	{$rule}.cmsmasters_dynamic_cart .cmsmasters_dynamic_cart_button:hover, 
	{$rule}.cmsmasters_dynamic_cart:hover .cmsmasters_dynamic_cart_button,
	{$rule}.woocommerce-store-notice, 
	{$rule}.woocommerce-store-notice p a, 
	{$rule}.woocommerce-store-notice p a:hover,
	{$rule}#page .widget_product_tag_cloud a, 
	{$rule}#page .widget_product_tag_cloud a:hover, 
	{$rule}.shop_table.order_details tfoot tr:last-child th, 
	{$rule}.shop_table.order_details tfoot tr:last-child td .amount, 
	{$rule}.cmsmasters_tabs.cmsmasters_woo_tabs .cmsmasters_tabs_list_item:hover a,
	{$rule}.cmsmasters_tabs.cmsmasters_woo_tabs .cmsmasters_tabs_list_item.current_tab a,
	{$rule}.shop_table tfoot .order-total .amount, 
	{$rule}.shop_table tfoot .order-total th,
	{$rule}.tribe-bar-views-toggle,
	{$rule}.tribe-bar-views-toggle:hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}#page .cmsmasters_dynamic_cart .remove, 
	{$rule}.woocommerce-store-notice .woocommerce-store-notice__dismiss-link {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_product .cmsmasters_product_add_wrap {
		background-color:rgba(" . color2rgb($cmsmasters_option['kids' . '_' . $scheme . '_bg']) . ", 0.85);
	}
	
	{$rule}.woocommerce textarea:focus:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.woocommerce textarea:focus::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.woocommerce input:focus:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.woocommerce input:focus::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	/* Finish Main Background Color */
	
	
	/* Start Alternate Background Color */
	{$rule}.onsale, 
	{$rule}.out-of-stock, 
	{$rule}.stock, 
	{$rule}.cmsmasters_star.cmsmasters_theme_icon_star_empty, 
	{$rule}ul.order_details {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . "
	}
	
	{$rule}.woocommerce-info, 
	{$rule}.woocommerce-message, 
	{$rule}.woocommerce-error, 
	{$rule}.cmsmasters_added_product_info, 
	{$rule}.widget_price_filter .price_slider, 
	{$rule}.cmsmasters_dynamic_cart .cmsmasters_added_product_info, 
	{$rule}.cmsmasters_dynamic_cart .widget_shopping_cart_content, 
	{$rule}.select2-container .select2-choice, 
	{$rule}.select2-container.select2-drop-above .select2-choice, 
	{$rule}.select2-container.select2-container-active .select2-choice, 
	{$rule}.select2-container.select2-container-active.select2-drop-above .select2-choice, 
	{$rule}.select2-container .select2-selection--single, 
	{$rule}.select2-drop.select2-drop-active, 
	{$rule}.select2-drop.select2-drop-above.select2-drop-active, 
	{$rule}.input-checkbox + label:before, 
	{$rule}.cmsmasters_dynamic_cart .cmsmasters_dynamic_cart_button, 
	{$rule}.input-radio + label:before, 
	{$rule}input.shipping_method + label:before, 
	{$rule}ul.order_details strong, 
	{$rule}.remove, 
	{$rule}.shop_table.my_account_orders tr td, 
	{$rule}.cmsmasters_tabs.cmsmasters_woo_tabs .cmsmasters_tabs_list_item a {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . "
	}
	
	{$rule}.cmsmasters_dynamic_cart .widget_shopping_cart_content:after {
		" . cmsmasters_color_css('border-bottom-color', $cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . "
	}
	
	/* Finish Alternate Background Color */
	
	
	/* Start Borders Color */
	{$rule}.cmsmasters_star_rating .cmsmasters_star_trans_wrap, 
	{$rule}.comment-form-rating .stars > span {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_border']) . "
	}
	
	{$rule}.cmsmasters_woo_tabs:before, 
	{$rule}div.products:before {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_border']) . "
	}
	
	{$rule}.select2-container .select2-choice, 
	{$rule}.select2-container.select2-drop-above .select2-choice, 
	{$rule}.input-checkbox + label:before, 
	{$rule}.input-radio + label:before, 
	{$rule}input.shipping_method + label:before, 
	{$rule}.shop_table th, 
	{$rule}.shop_table td, 
	{$rule}.cmsmasters_products .product.product-category img, 
	{$rule}.cart_totals table th, 
	{$rule}.cart_totals table td, 
	{$rule}.shop_table .cart_item {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_border']) . "
	}
	/* Finish Borders Color */
	
	
	/* Start Secondary Color */
	{$rule}.cmsmasters_product .button, 
	{$rule}.widget_product_tag_cloud a, 
	{$rule}.shop_table.order_details tfoot tr:last-child th, 
	{$rule}.shop_table.order_details tfoot tr:last-child td, 
	{$rule}.cmsmasters_tabs.cmsmasters_woo_tabs .cmsmasters_tabs_list_item.current_tab a, 
	{$rule}.cmsmasters_tabs.cmsmasters_woo_tabs .cmsmasters_tabs_list_item:hover a, 
	{$rule}.cmsmasters_dynamic_cart:hover .cmsmasters_dynamic_cart_button, 
	{$rule}.cmsmasters_dynamic_cart .cmsmasters_dynamic_cart_button:hover, 
	{$rule}.shop_table tfoot .order-total th, 
	{$rule}.shop_table tfoot .order-total td, 
	{$rule}.widget_price_filter .ui-slider-range, 
	{$rule}.onsale,
	{$rule}.tribe-bar-views-toggle:hover {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	{$rule}.shipping-calculator-button:hover, 
	{$rule}.required, 
	{$rule}.cmsmasters_products .product.product-category h2:hover, 
	{$rule}.cmsmasters_products .product.product-category h2 mark, 
	{$rule}#page .widget > .product_list_widget a:hover, 
	{$rule}.comment-form-rating .stars > span a:hover, 
	{$rule}.comment-form-rating .stars > span a.active, 
	{$rule}.shop_table a:not(.button):hover, 
	{$rule}.cmsmasters_dynamic_cart .widget_shopping_cart_content .cart_list a:hover, 
	{$rule}#page .woocommerce .widget_shopping_cart_content .cart_list a:hover, 
	{$rule}#page .woocommerce .remove:hover, 
	{$rule}.cmsmasters_star.cmsmasters_theme_icon_star_full {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	/* Finish Secondary Color */
	
/***************** Finish {$title} WooCommerce Color Scheme Rules ******************/


";
		}
		
		
		if (CMSMASTERS_EVENTS_CALENDAR) {
			$custom_css .= "
/***************** Start {$title} Events Color Scheme Rules ******************/

	/* Start Main Content Font Color */
	{$rule}.tribe-mini-calendar tbody, 
	{$rule}.cmsmasters_single_event_meta .cmsmasters_event_meta_info_item_title, 
	{$rule}.cmsmasters_single_event .tribe-events-schedule, 
	{$rule}.cmsmasters_single_event .tribe-events-cost, 
	{$rule}#tribe-events input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]), 
	{$rule}.tribe-events-list .tribe-events-event-meta, 
	{$rule}.tribe-events-photo .tribe-events-event-meta, 
	{$rule}#tribe-bar-views .tribe-bar-views-list li, 
	{$rule}table.tribe-events-calendar tbody td div[id*=tribe-events-daynum-], 
	{$rule}table.tribe-events-calendar tbody td div[id*=tribe-events-daynum-] a, 
	{$rule}.tribe-this-week-events-widget .tribe-events-page-title, 
	{$rule}.tribe-this-week-events-widget .tribe-this-week-event .tribe-venue a {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}#tribe-events textarea::-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}#tribe-events textarea::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}#tribe-events input::-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}#tribe-events input::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	
	/* Finish Main Content Font Color */
	
	
	/* Start Primary Color */
	{$rule}#tribe-bar-views .tribe-bar-views-list li:hover, 
	{$rule}table.tribe-events-calendar tbody td.tribe-events-past div[id*=tribe-events-daynum-] a, 
	{$rule}.tribe-events-venue .cmsmasters_events_venue_header_right a:before, 
	{$rule}.tribe-events-venue .cmsmasters_events_venue_header_right a:hover, 
	{$rule}.tribe-events-organizer .cmsmasters_events_organizer_header_right a:before, 
	{$rule}.tribe-events-organizer .cmsmasters_events_organizer_header_right a:hover, 
	{$rule}.tribe-mini-calendar tbody a:hover, 
	{$rule}.tribe-mini-calendar tbody .tribe-events-othermonth, 
	{$rule}.tribe-mini-calendar tbody .tribe-events-othermonth a, 
	{$rule}.tribe-mini-calendar-list-wrapper [class*=cmsmasters_theme_icon]:before, 
	{$rule}.tribe-events-countdown-widget .tribe-countdown-text a:hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_event_date, 
	{$rule}table.tribe-events-calendar tbody td.tribe-events-has-events:before {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	/* Finish Primary Color */
	
	
	/* Start Highlight Color */
	{$rule}.event_hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}
	/* Finish Highlight Color */
	
	
	/* Start Headings Color */
	{$rule}.tribe-bar-filters-inner > div label, 
	{$rule}#tribe-bar-views .tribe-bar-views-list li:hover, 
	{$rule}#tribe-bar-views .tribe-bar-views-list li.tribe-bar-active, 
	{$rule}.tribe-events-sub-nav li a, 
	{$rule}.tribe-events-notices, 
	{$rule}.tribe-mini-calendar tbody a, 
	{$rule}.tribe-events-list .tribe-events-list-separator-month, 
	{$rule}.tribe-events-grid .tribe-week-event:hover .vevent .entry-title a, 
	{$rule}.cmsmasters_single_event_meta dt, 
	{$rule}.tribe-events-venue .tribe-events-event-meta, 
	{$rule}.tribe-events-venue .cmsmasters_events_venue_header_right a, 
	{$rule}.tribe-events-organizer .tribe-events-event-meta, 
	{$rule}.tribe-events-organizer .cmsmasters_events_organizer_header_right a, 
	{$rule}.tribe-mini-calendar thead a:hover, 
	{$rule}.tribe-this-week-events-widget .tribe-this-week-event .entry-title a, 
	{$rule}.tribe-events-grid .tribe-grid-header a:hover, 
	{$rule}.tribe-events-venue-widget .vcalendar .entry-title a, 
	{$rule}.tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info, 
	{$rule}.tribe-events-venue-widget .tribe-venue-widget-venue-name a, 
	{$rule}.tribe-events-countdown-widget .tribe-countdown-time, 
	{$rule}.tribe-events-countdown-widget .tribe-countdown-text, 
	{$rule}.tribe-events-countdown-widget .tribe-countdown-text a, 
	{$rule}.tribe-mobile-day .tribe-events-event-schedule-details, 
	{$rule}.tribe-mobile-day .tribe-event-schedule-details {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_heading']) . "
	}
	
	{$rule}.tribe-mini-calendar .tribe-mini-calendar-nav, 
	{$rule}table.tribe-events-calendar thead th, 
	{$rule}.tribe-events-grid .tribe-grid-header, 
	{$rule}.tribe-events-grid .tribe-events-tooltip, 
	{$rule}table.tribe-events-calendar tbody td.tribe-events-has-events.mobile-active:before {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_heading']) . "
	}
	/* Finish Headings Color */
	
	
	/* Start Main Background Color */
	{$rule}.tribe-events-tooltip, 
	{$rule}.tribe-events-tooltip *, 
	{$rule}.tribe-mini-calendar thead, 
	{$rule}#page .tribe-mini-calendar thead a, 
	{$rule}.tribe-events-grid .tribe-week-event .vevent .entry-title a, 
	{$rule}table.tribe-events-calendar thead th, 
	{$rule}.tribe-events-grid .tribe-grid-header, 
	{$rule}.tribe-events-grid .tribe-grid-header a, 
	{$rule}.tribe-events-grid .tribe-grid-header .tribe-week-today, 
	{$rule}.tribe-events-sub-nav li a:hover, 
	{$rule}.widget.tribe-events-adv-list-widget .tribe-events-list-widget-content-wrap a:hover, 
	{$rule}.tribe-this-week-events-widget .this-week-today .tribe-this-week-widget-header-date, 
	{$rule}#tribe-events input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]):focus, 
	{$rule}table.tribe-events-calendar tbody td div[id*=tribe-events-daynum-] a:hover, 
	{$rule}.tribe-events-adv-list-widget .tribe-events-list-widget-content-wrap, 
	{$rule}.tribe-events-adv-list-widget .tribe-events-list-widget-content-wrap a, 
	{$rule}table.tribe-events-calendar tbody td.tribe-events-present div[id*=tribe-events-daynum-], 
	{$rule}table.tribe-events-calendar tbody td.tribe-events-present div[id*=tribe-events-daynum-] a, 
	{$rule}.event_bg {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.tribe-events-grid .tribe-week-event .vevent .entry-title {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.tribe-mini-calendar tbody a:before, 
	{$rule}.tribe-events-grid .tribe-scroller, 
	{$rule}.tribe-events-grid .tribe-week-grid-hours {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}#tribe-events textarea:focus::-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}#tribe-events textarea:focus::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}#tribe-events input:focus::-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}#tribe-events input:focus::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	/* Finish Main Background Color */
	
	
	/* Start Alternate Background Color */  
	{$rule}.cmsmasters_event_date {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . "
	}
	
	{$rule}table.tribe-events-calendar tbody td div[id*=tribe-events-daynum-], 
	{$rule}.tribe-events-notices, 
	{$rule}.tribe-events-sub-nav li.tribe-events-nav-next span:not([class]), 
	{$rule}.tribe-events-sub-nav li.tribe-events-nav-previous span:not([class]), 
	{$rule}.tribe-events-sub-nav li.nav-next span:not([class]), 
	{$rule}.tribe-events-grid .tribe-grid-header a:hover, 
	{$rule}.tribe-events-grid .tribe-week-event:hover .vevent .entry-title a, 
	{$rule}#tribe-bar-views .tribe-bar-views-list li.tribe-bar-active, 
	{$rule}.tribe-mini-calendar, 
	{$rule}.tribe-events-venue-widget .tribe-venue-widget-venue {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . "
	}
	/* Finish Alternate Background Color */
	
	
	/* Start Borders Color */
	{$rule}table.tribe-events-calendar tbody td.tribe-events-othermonth div[id*=tribe-events-daynum-] {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_border']) . "
	}
	
	.tribe-events-photo #tribe-events-photo-events:before, 
	.tribe-events-single .post_nav:before, 
	.tribe-events-single .post_nav:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_border']) . "
	}
	
	{$rule}table.tribe-events-calendar, 
	{$rule}table.tribe-events-calendar tbody td, 
	{$rule}table.tribe-events-calendar tbody td .tribe_events, 
	{$rule}.tribe-events-list .tribe-events-list-separator-month, 
	{$rule}.tribe-events-list .tribe-events-day-time-slot > h5, 
	{$rule}.tribe-events-list .type-tribe_events, 
	{$rule}.tribe-events-photo .tribe-events-page-title, 
	{$rule}.tribe-events-map .tribe-events-page-title, 
	{$rule}.tribe-events-grid .tribe-scroller, 
	{$rule}.tribe-events-grid .tribe-week-grid-block div, 
	{$rule}.tribe-events-grid .tribe-grid-allday, 
	{$rule}.tribe-events-grid .tribe-grid-content-wrap .column, 
	{$rule}.tribe-events-grid .tribe-week-grid-hours div, 
	{$rule}.cmsmasters_single_event, 
	{$rule}.widget .vcalendar .type-tribe_events, 
	{$rule}.tribe-mini-calendar-list-wrapper .type-tribe_events, 
	{$rule}.tribe-mobile-day .tribe-events-mobile, 
	{$rule}.tribe-this-week-events-widget .tribe-this-week-widget-day {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_border']) . "
	}
	/* Finish Borders Color */
	
	/* Start Secondary Color */
	{$rule}.tribe-events-tooltip, 
	{$rule}.tribe-events-sub-nav li.tribe-events-nav-next:hover span:not([class]), 
	{$rule}.tribe-events-sub-nav li.tribe-events-nav-previous:hover span:not([class]), 
	{$rule}.tribe-this-week-events-widget .this-week-today .tribe-this-week-widget-header-date, 
	{$rule}.tribe-mini-calendar thead, 
	{$rule}.tribe-events-grid .tribe-week-event .vevent .entry-title a, 
	{$rule}.tribe-events-grid .tribe-grid-header .tribe-week-today, 
	{$rule}#tribe-bar-views.tribe-bar-views-open .button, 
	{$rule}.tribe-events-adv-list-widget .tribe-events-list-widget-content-wrap, 
	{$rule}table.tribe-events-calendar tbody td div[id*=tribe-events-daynum-] a:hover, 
	{$rule}.tribe-events-sub-nav li a:hover > span, 
	{$rule}table.tribe-events-calendar tbody td.tribe-events-present div[id*=tribe-events-daynum-] {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	{$rule}.tribe-events-countdown-widget .tribe-countdown-time span, 
	{$rule}.tribe-events-photo .time-details:before, 
	{$rule}.tribe-events-venue-widget .cmsmasters_widget_event_info > div:before, 
	{$rule}.tribe-events-venue-widget .tribe-venue-widget-venue-name:before, 
	{$rule}.tribe-this-week-events-widget .tribe-this-week-event .entry-title a:hover, 
	{$rule}#page .tribe-mini-calendar tbody a:hover, 
	{$rule}#page .tribe-mini-calendar thead a:hover, 
	{$rule}.tribe-events-venue-widget .vcalendar .entry-title a:hover, 
	{$rule}.tribe-events-venue-widget .tribe-venue-widget-venue-name a:hover, 
	{$rule}.tribe-this-week-events-widget .tribe-this-week-event .duration:before, 
	{$rule}.tribe-this-week-events-widget .tribe-this-week-event .tribe-venue:before, 
	{$rule}.tribe-this-week-events-widget .tribe-events-sub-nav li a:hover, 
	{$rule}.tribe-mini-calendar tbody .tribe-events-present, 
	{$rule}.tribe-mini-calendar tbody .tribe-events-present a, 
	{$rule}.cmsmasters_single_event .tribe-events-date:before, 
	{$rule}.cmsmasters_single_event .cmsmasters_single_event_header_right a:before, 
	{$rule}.cmsmasters_single_event .tribe-events-cost:before, 
	{$rule}.tribe-events-list .tribe-events-event-meta .author > div:before {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	.tribe-this-week-events-widget .tribe-events-sub-nav li a:hover > span {
		background-color:transparent;
	}
	
	.tribe_mini_calendar_widget .tribe-events-list-widget-content-wrap {
		background-color:transparent !important;
	}
	
	{$rule}.recurringinfo .recurring-info-tooltip:before {
		" . cmsmasters_color_css('border-bottom-color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	{$rule}.tribe-events-tooltip:before {
		" . cmsmasters_color_css('border-top-color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	/* Finish Secondary Color */
/***************** Finish {$title} Events Color Scheme Rules ******************/


";
		}
	}
	
	
	$custom_css .= "
/***************** Start Header Middle Color Scheme Rules ******************/

	/* Start Header Middle Content Color */
	.header_mid,
	.header_mid textarea,
	.header_mid select,
	.header_mid option {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_color']) . "
	}
	/* Finish Header Middle Content Color */
	
	
	/* Start Header Middle Primary Color */
	.header_mid a,
	.header_mid .cmsmasters_social_icon:hover,
	.header_mid .search_wrap .search_bar_wrap .search_button button {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_link']) . "
	}
	
	.header_mid .button:hover, 
	.header_mid input[type=submit]:hover, 
	.header_mid input[type=button]:hover, 
	.header_mid .resp_mid_nav_wrap .resp_mid_nav, 
	.header_mid .cmsmasters_dynamic_cart_wrap .cmsmasters_dynamic_cart_button, 
	.header_mid input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]) {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_mid_link']) . "
	}
	
	.header_mid input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]):focus,
	.header_mid input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]) {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_header_mid_link']) . "
	}
	/* Finish Header Middle Primary Color */
	
	
	/* Start Header Middle Rollover Color */
	.header_mid a:hover,
	.header_mid .search_wrap .search_bar_wrap .search_button button:hover	{
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_hover']) . "
	}
	
	.header_mid .button, 
	.header_mid input[type=submit], 
	.header_mid input[type=button], 
	.header_mid button,
	.header_mid .cmsmasters_dynamic_cart_wrap .cmsmasters_dynamic_cart_button:hover, 
	.header_mid .resp_mid_nav_wrap .resp_mid_nav:hover, 
	.header_mid .resp_mid_nav_wrap .resp_mid_nav.active {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_mid_hover']) . "
	}
	
	.header_mid textarea:focus,
	.header_mid select:focus {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_header_mid_hover']) . "
	}
	/* Finish Header Middle Rollover Color */
	
	
	/* Start Header Middle Background Color */
	.header_mid .button, 
	.header_mid input[type=submit], 
	.header_mid input[type=button], 
	.header_mid button, 
	.header_mid .cmsmasters_social_icon,
	.header_mid .button:hover, 
	.header_mid input[type=submit]:hover, 
	.header_mid input[type=button]:hover, 
	.header_mid .cmsmasters_dynamic_cart_wrap .cmsmasters_dynamic_cart_button,
	.header_mid .cmsmasters_dynamic_cart_wrap .cmsmasters_dynamic_cart_button:hover,
	.header_mid .resp_mid_nav_wrap .resp_mid_nav, 
	.header_mid .resp_mid_nav_wrap .resp_mid_nav:hover, 
	.header_mid .resp_mid_nav_wrap .resp_mid_nav.active {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg']) . "
	}
	
	.header_mid,
	.header_mid textarea,
	.header_mid select,
	.header_mid option {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_mid_bg']) . "
	}
	
	.header_mid:before {
		background-image: -webkit-gradient(linear, 0 0, 300% 100%, color-stop(0.25, " . $cmsmasters_option['kids' . '_header_mid_bg'] . "), color-stop(0.25, " . $cmsmasters_option['kids' . '_header_mid_bg'] . "));
		background-image: linear-gradient(135deg, " . $cmsmasters_option['kids' . '_header_mid_bg'] . " 25%, transparent 25%), linear-gradient(225deg, " . $cmsmasters_option['kids' . '_header_mid_bg'] . " 25%, transparent 25%);
	}
	
	@media only screen and (max-width: 768px) {
		#header .header_mid .search_wrap .search_bar_wrap .search_button button {
			" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg']) . "
		}
	}
	
	.header_mid input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]):focus {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg']) . "
	}
	
	.header_mid input:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg']) . "
	}
	
	.header_mid input::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg']) . "
	}
	
	.header_mid input:focus:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg']) . "
	}
	
	.header_mid input:focus::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg']) . "
	}
	
	
	/* Finish Header Middle Background Color */
	
	
	/* Start Header Middle Background Color on Scroll */
	.header_mid.header_mid_scroll {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_mid_bg_scroll']) . "
	}
	
	.header_mid.header_mid_scroll:before {
		background-image: -webkit-gradient(linear, 0 0, 300% 100%, color-stop(0.25, " . $cmsmasters_option['kids' . '_header_mid_bg_scroll'] . "), color-stop(0.25, " . $cmsmasters_option['kids' . '_header_mid_bg_scroll'] . "));
		background-image: linear-gradient(135deg, " . $cmsmasters_option['kids' . '_header_mid_bg_scroll'] . " 25%, transparent 25%), linear-gradient(225deg, " . $cmsmasters_option['kids' . '_header_mid_bg_scroll'] . " 25%, transparent 25%);
	}
	
	.header_mid input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]):focus {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg_scroll']) . "
	}
	
	.header_mid input:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg_scroll']) . "
	}
	
	.header_mid input::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg_scroll']) . "
	}
	
	.header_mid input:focus:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg_scroll']) . "
	}
	
	.header_mid input:focus::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg_scroll']) . "
	}
	
	@media only screen and (max-width: 1024px) {
		.header_mid {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_mid_bg_scroll']) . "
		}
	}
	/* Finish Header Middle Background Color on Scroll */
	
	
	/* Start Header Middle Borders Color */
	.header_mid textarea,
	.header_mid select,
	.header_mid option {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_header_mid_border']) . "
	}
	
	.header_mid:after {
		background-image: -webkit-gradient(linear, 0 0, 300% 100%, color-stop(0.25, " . $cmsmasters_option['kids' . '_header_mid_border'] . "), color-stop(0.25, " . $cmsmasters_option['kids' . '_header_mid_border'] . "));
		background-image: linear-gradient(135deg, " . $cmsmasters_option['kids' . '_header_mid_border'] . " 25%, transparent 25%), linear-gradient(225deg, " . $cmsmasters_option['kids' . '_header_mid_border'] . " 25%, transparent 25%);
	}
	
	
	/* Finish Header Middle Borders Color */
	
	
	/* Start Header Middle Custom Rules */
	.header_mid ::selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['kids' . '_header_mid_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg']) . "
	}
	
	.header_mid ::-moz-selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['kids' . '_header_mid_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_mid_bg']) . "
	}
	/* Finish Header Middle Custom Rules */

/***************** Finish Header Middle Color Scheme Rules ******************/



/***************** Start Header Bottom Color Scheme Rules ******************/

	/* Start Header Bottom Content Color */
	.header_bot,
	.header_bot input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]),
	.header_bot textarea,
	.header_bot select,
	.header_bot option {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_bot_color']) . "
	}
	/* Finish Header Bottom Content Color */
	
	
	/* Start Header Bottom Primary Color */
	.header_bot a {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_bot_link']) . "
	}
	
	.header_bot .button:hover, 
	.header_bot input[type=submit]:hover, 
	.header_bot input[type=button]:hover, 
	.header_bot button:hover, 
	.header_bot .resp_bot_nav_wrap .resp_bot_nav {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_bot_link']) . "
	}
	/* Finish Header Bottom Primary Color */
	
	
	/* Start Header Bottom Rollover Color */
	.header_bot a:hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_bot_hover']) . "
	}
	
	.header_bot .button, 
	.header_bot input[type=submit], 
	.header_bot input[type=button], 
	.header_bot button,
	.header_bot .resp_bot_nav_wrap .resp_bot_nav:hover, 
	.header_bot .resp_bot_nav_wrap .resp_bot_nav.active {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_bot_hover']) . "
	}
	
	.header_bot input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]):focus,
	.header_bot textarea:focus,
	.header_bot select:focus {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_header_bot_hover']) . "
	}
	/* Finish Header Bottom Rollover Color */
	
	
	/* Start Header Bottom Background Color */
	.header_bot .button, 
	.header_bot input[type=submit], 
	.header_bot input[type=button], 
	.header_bot button, 
	.header_bot .resp_bot_nav_wrap .resp_bot_nav, 
	.header_bot .resp_bot_nav_wrap .resp_bot_nav:hover, 
	.header_bot .resp_bot_nav_wrap .resp_bot_nav.active {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_bot_bg']) . "
	}
	
	.header_bot,
	.header_bot input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]),
	.header_bot textarea,
	.header_bot select,
	.header_bot option {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_bot_bg']) . "
	}
	
	.header_bot:before {
		background-image: -webkit-gradient(linear, 0 0, 300% 100%, color-stop(0.25, " . $cmsmasters_option['kids' . '_header_bot_bg'] . "), color-stop(0.25, " . $cmsmasters_option['kids' . '_header_bot_bg'] . "));
		background-image: linear-gradient(135deg, " . $cmsmasters_option['kids' . '_header_bot_bg'] . " 25%, transparent 25%), linear-gradient(225deg, " . $cmsmasters_option['kids' . '_header_bot_bg'] . " 25%, transparent 25%);
	}
	/* Finish Header Bottom Background Color */
	
	
	/* Start Header Bottom Background Color on Scroll */
	.header_bot.header_bot_scroll {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_bot_bg_scroll']) . "
	}
	
	.header_bot.header_bot_scroll:before {
		background-image: -webkit-gradient(linear, 0 0, 300% 100%, color-stop(0.25, " . $cmsmasters_option['kids' . '_header_bot_bg_scroll'] . "), color-stop(0.25, " . $cmsmasters_option['kids' . '_header_bot_bg_scroll'] . "));
		background-image: linear-gradient(135deg, " . $cmsmasters_option['kids' . '_header_bot_bg_scroll'] . " 25%, transparent 25%), linear-gradient(225deg, " . $cmsmasters_option['kids' . '_header_bot_bg_scroll'] . " 25%, transparent 25%);
	}
	
	@media only screen and (max-width: 1024px) {
		.header_bot {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_bot_bg_scroll']) . "
		}
	}
	/* Finish Header Bottom Background Color on Scroll */
	
	
	/* Start Header Bottom Borders Color */
	.header_bot input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]),
	.header_bot textarea,
	.header_bot select,
	.header_bot option {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_header_bot_border']) . "
	}
	
	.header_bot:after {
		background-image: -webkit-gradient(linear, 0 0, 300% 100%, color-stop(0.25, " . $cmsmasters_option['kids' . '_header_bot_border'] . "), color-stop(0.25, " . $cmsmasters_option['kids' . '_header_bot_border'] . "));
		background-image: linear-gradient(135deg, " . $cmsmasters_option['kids' . '_header_bot_border'] . " 25%, transparent 25%), linear-gradient(225deg, " . $cmsmasters_option['kids' . '_header_bot_border'] . " 25%, transparent 25%);
	}
	
	/* Finish Header Bottom Borders Color */
	
	
	/* Start Header Bottom Custom Rules */
	.header_bot ::selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['kids' . '_header_bot_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_bot_bg']) . "
	}
	
	.header_bot ::-moz-selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['kids' . '_header_bot_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_bot_bg']) . "
	}
	/* Finish Header Bottom Custom Rules */

/***************** Finish Header Bottom Color Scheme Rules ******************/



/***************** Start Navigation Color Scheme Rules ******************/

	/* Start Navigation Title Link Color */
	@media only screen and (min-width: 1025px) {
		ul.navigation > li > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_navigation_title_link']) . "
		}
		
		.navigation li a .nav_tag {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_title_link']) . "
		}
	}
	/* Finish Navigation Title Link Color */
	
	
	/* Start Navigation Title Link Hover Color */
	@media only screen and (min-width: 1025px) {
		ul.navigation > li > a:hover,
		ul.navigation > li > a:hover .nav_subtitle,
		ul.navigation > li:hover > a,
		ul.navigation > li:hover > a .nav_subtitle {
			" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_navigation_title_link_hover']) . "
		}
		
		ul.navigation > li:hover > a .nav_tag {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_title_link_hover']) . "
		}
	}
	/* Finish Navigation Title Link Hover Color */
	
	
	/* Start Navigation Title Link Current Color */
	@media only screen and (min-width: 1025px) {
		ul.navigation > li.current_page_item > a .nav_subtitle, 
		ul.navigation > li.current_page_item > a, 
		ul.navigation > li.menu-item.current-menu-item > a, 
		ul.navigation > li.menu-item.current-menu-item > a .nav_subtitle, 
		ul.navigation > li.menu-item.current-menu-ancestor > a, 
		ul.navigation > li.menu-item.current-menu-ancestor > a .nav_subtitle,
		.navigation li a .nav_tag {
			" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_navigation_title_link_current']) . "
		}
		
		ul.navigation > li.current_page_item > a .nav_tag {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_title_link_current']) . "
		}
	}
	/* Finish Navigation Title Link Current Color */
	
	
	/* Start Navigation Title Link Subtitle Color */
	@media only screen and (min-width: 1025px) {
		ul.navigation > li > a .nav_subtitle,
		ul.navigation > li.current_page_item > a .nav_tag {
			" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_navigation_title_link_subtitle']) . "
		}
	}
	/* Finish Navigation Title Link Subtitle Color */
	
	
	/* Start Navigation Title Link Background Color */
	@media only screen and (min-width: 1025px) {
		ul.navigation > li > a, 
		ul.navigation > li > a:after {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_title_link_bg']) . "
		}
	}
	/* Finish Navigation Title Link Background Color */
	
	
	/* Start Navigation Title Link Hover Background Color */
	@media only screen and (min-width: 1025px) {
		ul.navigation > li > a:hover,
		ul.navigation > li:hover > a, 
		ul.navigation > li > a:hover:after,
		ul.navigation > li:hover > a:after {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_title_link_bg_hover']) . "
		}
	}
	/* Finish Navigation Title Link Hover Background Color */
	
	
	/* Start Navigation Title Link Current Background Color */
	@media only screen and (min-width: 1025px) {
		ul.navigation > li.current_page_item > a, 
		ul.navigation > li.menu-item.current-menu-item > a, 
		ul.navigation > li.menu-item.current-menu-ancestor > a, 
		ul.navigation > li.current_page_item > a:after, 
		ul.navigation > li.menu-item.current-menu-item > a:after, 
		ul.navigation > li.menu-item.current-menu-ancestor > a:after {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_title_link_bg_current']) . "
		}
	}
	/* Finish Navigation Title Link Current Background Color */
	
	
	/* Start Navigation Title Link Border Color */
	@media only screen and (min-width: 1025px) {
		ul.navigation > li > a {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_navigation_title_link_border']) . "
		}
	}
	/* Finish Navigation Title Link Border Color */
	
	
	/* Start Navigation Dropdown Text Color */
	.navigation li .menu-item-mega-description-container, 
	.navigation li .menu-item-mega-description-container * {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_navigation_dropdown_text']) . "
	}
	/* Finish Navigation Dropdown Tex Color */
	
	
	/* Start Navigation Dropdown Background Color */
	@media only screen and (max-width: 1024px) {
		ul.navigation {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_dropdown_bg']) . "
		}
	}
	
	@media only screen and (min-width: 1025px) {
		ul.navigation ul, 
		ul.navigation .menu-item-mega-container {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_dropdown_bg']) . "
		}
		
		.mid_nav > li > ul:after,
		.bot_nav > li > ul:after {
			" . cmsmasters_color_css('border-bottom-color', $cmsmasters_option['kids' . '_navigation_dropdown_bg']) . "
		}
		
		.bot_nav ul ul li:first-child:before, 
		.mid_nav ul ul li:first-child:before {
			" . cmsmasters_color_css('border-right-color', $cmsmasters_option['kids' . '_navigation_dropdown_bg']) . "
		}
	}
	/* Finish Navigation Dropdown Background Color */
	
	
	/* Start Navigation Dropdown Border Color */
	@media only screen and (min-width: 1025px) {
		ul.navigation ul, 
		ul.navigation .menu-item-mega-container {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_navigation_dropdown_border']) . "
		}
	}
	/* Finish Navigation Dropdown Border Color */
	
	
	/* Start Navigation Dropdown Link Color */
	.navigation .cmsmasters_resp_nav_toggle, 
	.navigation li a {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_navigation_dropdown_link']) . "
	}
	
	/* Finish Navigation Dropdown Link Color */
	
	
	/* Start Navigation Dropdown Link Hover Color */
	.navigation li > a:hover,
	.navigation li > a:hover .nav_subtitle,
	.navigation li.current-menu-item > a, 
	.navigation li.current-menu-item > a .nav_subtitle {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_navigation_dropdown_link_hover']) . "
	}
	
	.navigation li.current-menu-item > a .cmsmasters_resp_nav_toggle, 
	.navigation li > a .cmsmasters_resp_nav_toggle.cmsmasters_theme_icon_resp_nav_slide_up, 
	.navigation li > a:hover .cmsmasters_resp_nav_toggle {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_dropdown_link_hover']) . "
	}
	
	@media only screen and (min-width: 1025px) {
		ul.navigation li > ul li:hover > a, 
		ul.navigation li > ul li:hover > a .nav_subtitle, 
		ul.navigation li > ul li.current-menu-ancestor > a, 
		ul.navigation li > ul li.current-menu-ancestor > a .nav_subtitle {
			" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_navigation_dropdown_link_hover']) . "
		}
	}
	/* Finish Navigation Dropdown Link Hover Color */
	
	
	/* Start Navigation Dropdown Link Subtitle Color */
	.navigation li a .nav_subtitle {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_navigation_dropdown_link_subtitle']) . "
	}
	/* Finish Navigation Dropdown Link Subtitle Color */
	
	
	/* Start Navigation Dropdown Link Hover Highlight Color */
	.navigation li > a:hover,
	.navigation .cmsmasters_resp_nav_toggle, 
	.navigation li.current-menu-item > a {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_dropdown_link_highlight']) . "
	}
	
	
	.navigation li.current-menu-item > a .cmsmasters_resp_nav_toggle, 
	.navigation li > a .cmsmasters_resp_nav_toggle.cmsmasters_theme_icon_resp_nav_slide_up, 
	.navigation li > a:hover .cmsmasters_resp_nav_toggle {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_navigation_dropdown_link_highlight']) . "
	}
	
	@media only screen and (min-width: 1025px) {
		ul.navigation li > ul li:hover > a, 
		ul.navigation li > ul li.current-menu-ancestor > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_navigation_dropdown_link_highlight']) . "
		}
		
		.bot_nav ul ul li:first-child:hover:before, 
		.mid_nav ul ul li.current_page_item:first-child:before, 
		.mid_nav ul ul li:first-child:hover:before,
		.bot_nav ul ul li.current_page_item:first-child:before {
			" . cmsmasters_color_css('border-right-color', $cmsmasters_option['kids' . '_navigation_dropdown_link_highlight']) . "
		}
	}
	/* Finish Navigation Dropdown Link Hover Highlight Color */
	
	
	/* Start Navigation Dropdown Link Border Color */
	.navigation li {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_navigation_dropdown_link_border']) . "
	}
	/* Finish Navigation Dropdown Link Border Color */

/***************** Finish Navigation Color Scheme Rules ******************/



/***************** Start Header Top Color Scheme Rules ******************/

	/* Start Header Top Content Color */
	.header_top,
	.header_top .meta_wrap [class^=cmsmasters-icon-]:before,
	.header_top .meta_wrap [class*= cmsmasters-icon-]:before {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_color']) . "
	}
	/* Finish Header Top Content Color */
	
	
	/* Start Header Top Primary Color */
	.header_top a, 
	.header_top .responsive_top_nav:hover, 
	.header_top .responsive_top_nav.active, 
	.header_top .cmsmasters_social_icon:hover, 
	.header_top .header_top_but, 
	.header_top .header_top_but:hover, 
	.header_top .header_top_but.opened {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_link']) . "
	}
	
	.header_top .responsive_top_nav {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_top_link']) . "
	}
	/* Finish Header Top Primary Color */
	
	
	/* Start Header Top Rollover Color */
	.header_top a:hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_hover']) . "
	}
	
	.header_top .responsive_top_nav:hover, 
	.header_top .responsive_top_nav.active, 
	.header_top .cmsmasters_social_icon:hover {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_top_hover']) . "
	}
	/* Finish Header Top Rollover Color */
	
	
	/* Start Header Top Background Color */	
	.header_top {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_top_bg']) . "
	}
	
	.header_top .cmsmasters_social_icon {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_bg']) . "
	}
	
	/* Finish Header Top Background Color */
	
	
	/* Start Header Top Borders Color */
	.header_top .header_top_but {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_header_top_border']) . "
	}
	
	.header_top .header_top_left, 
	.header_top .header_top_right {
		border-color:rgba(" . color2rgb($cmsmasters_option['kids' . '_header_top_border']) . ", 0.10);
	}
	
	
	/* Finish Header Top Borders Color */
	
	/* Start Header Top Borders Color */
	
	.header_top .responsive_top_nav {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_dropdown_link']) . "
	}
	
	/* Finish Header Top Borders Color */
	
	/* Start Header Top Custom Rules */
	.header_top ::selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['kids' . '_header_top_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_bg']) . "
	}
	
	.header_top ::-moz-selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['kids' . '_header_top_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_bg']) . "
	}
	/* Finish Header Top Custom Rules */

/***************** Finish Header Top Color Scheme Rules ******************/



/***************** Start Header Top Navigation Color Scheme Rules ******************/

	/* Start Header Top Navigation Title Link Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav > li > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_title_link']) . "
		}
	}
	/* Finish Header Top Navigation Title Link Color */
	
	
	/* Start Header Top Navigation Title Link Hover Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav > li > a:hover,
		ul.top_line_nav > li:hover > a,
		ul.top_line_nav > li.current-menu-item > a,
		ul.top_line_nav > li.current-menu-ancestor > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_title_link_hover']) . "
		}
	}
	/* Finish Header Top Navigation Title Link Hover Color */
	
	
	/* Start Header Top Navigation Title Link Background Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav > li > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_top_title_link_bg']) . "
		}
	}
	/* Finish Header Top Navigation Title Link Background Color */
	
	
	/* Start Header Top Navigation Title Link Hover Background Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav > li > a:hover,
		ul.top_line_nav > li:hover > a,
		ul.top_line_nav > li.current-menu-item > a,
		ul.top_line_nav > li.current-menu-ancestor > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_top_title_link_bg_hover']) . "
		}
	}
	/* Finish Header Top Navigation Title Link Hover Background Color */
	
	
	/* Start Header Top Navigation Title Link Border Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav > li {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_header_top_title_link_border']) . "
		}
	}
	/* Finish Header Top Navigation Title Link Border Color */
	
	
	/* Start Header Top Navigation Dropdown Background Color */
	@media only screen and (max-width: 1024px) {
		ul.top_line_nav {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_top_dropdown_bg']) . "
		}
	}
	
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav ul {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_top_dropdown_bg']) . "
		}
		
		.top_line_nav > li > ul:after {
			" . cmsmasters_color_css('border-bottom-color', $cmsmasters_option['kids' . '_header_top_dropdown_bg']) . "
		}
		
		.top_line_nav ul ul li:first-child:before {
			" . cmsmasters_color_css('border-right-color', $cmsmasters_option['kids' . '_header_top_dropdown_bg']) . "
		}
	}
	/* Finish Header Top Navigation Dropdown Background Color */
	
	
	/* Start Header Top Navigation Dropdown Border Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav ul {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_header_top_dropdown_border']) . "
		}
	}
	/* Finish Header Top Navigation Dropdown Border Color */
	
	
	/* Start Header Top Navigation Dropdown Link Color */
	.top_line_nav li a {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_dropdown_link']) . "
	}
	/* Finish Header Top Navigation Dropdown Link Color */
	
	
	/* Start Header Top Navigation Dropdown Link Hover Color */
	.top_line_nav li > a:hover,
	.top_line_nav li.current-menu-item > a {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_dropdown_link_hover']) . "
	}
	
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav ul li:hover > a, 
		ul.top_line_nav ul li.current-menu-ancestor > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_header_top_dropdown_link_hover']) . "
		}
	}
	/* Finish Header Top Navigation Dropdown Link Hover Color */
	
	
	/* Start Header Top Navigation Dropdown Link Hover Highlight Color */
	.top_line_nav li > a:hover,
	.top_line_nav li.current-menu-item > a {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_top_dropdown_link_highlight']) . "
	}
	
	.top_line_nav ul ul li.current_page_item:first-child:before,
	.top_line_nav ul ul li:first-child:hover:before {
		" . cmsmasters_color_css('border-right-color', $cmsmasters_option['kids' . '_header_top_dropdown_link_highlight']) . "
	}
	
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav ul li:hover > a,
		ul.top_line_nav ul li.current-menu-ancestor > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_header_top_dropdown_link_highlight']) . "
		}
	}
	/* Finish Header Top Navigation Dropdown Link Hover Highlight Color */
	
	
	/* Start Header Top Navigation Dropdown Link Border Color */
	.top_line_nav li {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_header_top_dropdown_link_border']) . "
	}
	/* Finish Header Top Navigation Dropdown Link Border Color */

/***************** Finish Header Top Navigation Color Scheme Rules ******************/

";
	
	
	return apply_filters('kids_theme_colors_secondary_filter', $custom_css);
}

