<?php
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version 	1.1.5
 * 
 * Theme Primary Color Schemes Rules
 * Created by CMSMasters
 * 
 */


function kids_theme_colors_primary() {
	$cmsmasters_option = kids_get_global_options();
	
	
	$cmsmasters_color_schemes = cmsmasters_color_schemes_list();
	
	
	$custom_css = "/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version 	1.1.5
 * 
 * Theme Primary Color Schemes Rules
 * Created by CMSMasters
 * 
 */

";
	
	
	foreach ($cmsmasters_color_schemes as $scheme => $title) {
		$rule = (($scheme != 'default') ? "html .cmsmasters_color_scheme_{$scheme} " : '');
		
		
		$custom_css .= "
/***************** Start {$title} Color Scheme Rules ******************/

	/* Start Main Content Font Color */
	" . (($scheme == 'default') ? "body," : '') . "
	" . (($scheme != 'default') ? ".cmsmasters_color_scheme_{$scheme}," : '') . "
	{$rule}.blog.opened-article .cmsmasters_comment_item_title,
	{$rule}.cmsmasters_comment_item_title,
	{$rule}.blog.opened-article .cmsmasters_comment_item_title a,
	{$rule}.cmsmasters_comment_item_title a,
	{$rule}.widget .form_info,
	{$rule}.widget select,
	{$rule}.widget option,
	{$rule}.widget .cmsmasters_slider_project_inner,
	{$rule}.blog .cmsmasters_post_default .cmsmasters_post_author,
	{$rule}.blog .cmsmasters_post_default .cmsmasters_post_category,
	{$rule}.blog .cmsmasters_post_default .cmsmasters_post_content,
	{$rule}.blog.opened-article .cmsmasters_post_author,
	{$rule}.blog.opened-article .cmsmasters_post_category,
	{$rule}.blog.opened-article .cmsmasters_post_content,
	{$rule}.blog.opened-article .cmsmasters_post_tags,
	{$rule}select,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_tab.tab_comments .color_2,
	{$rule}.cmsmasters_quote_site,
	{$rule}.cmsmasters_quote_site a,
	{$rule}option {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_color']) . "
	}
	/* Finish Main Content Font Color */
	
	
	/* Start Primary Color */
	{$rule}a,
	{$rule}.color_2,
	{$rule}.cmsmasters_quotes_slider .cmsmasters_quote_content, 
	{$rule}.footer_inner .cmsmasters_social_icon, 
	{$rule}.cmsmasters_profile_subtitle, 
	{$rule}aside.widget a, 
	{$rule}.blog .cmsmasters_post_default a, 
	{$rule}.blog.opened-article a, 
	{$rule}.cmsmasters_quote_subtitle, 
	{$rule}.cmsmasters_dropcap.type1, 
	{$rule}.cmsmasters_archive_item_type, 
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li a, 
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_top:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_heading_left .icon_box_heading:before,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_icon .cmsmasters_icon_list_icon:before,
	{$rule}.cmsmasters_stats.stats_mode_circles .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner:before, 
	{$rule}.bypostauthor > .comment-body .alignleft:before,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > a:hover,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_block > span,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > ul > li > a:hover,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap_category > li > a:hover,
	{$rule}.cmsmasters_attach_img .cmsmasters_attach_img_edit a, 
	{$rule}.cmsmasters_attach_img .cmsmasters_attach_img_meta a {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	" . (($scheme == 'default') ? "mark," : '') . "
	" . (($scheme != 'default') ? ".cmsmasters_color_scheme_{$scheme} mark," : '') . "
	{$rule}.cmsmasters_dropcap.type2,
	{$rule}.headline_outer, 
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_top:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left_top:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left:before,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_bg .cmsmasters_icon_list_item .cmsmasters_icon_list_icon,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_icon .cmsmasters_icon_list_item:hover .cmsmasters_icon_list_icon,
	{$rule}.cmsmasters_stats.stats_mode_bars .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner, 
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=checkbox] + span.wpcf7-list-item-label:after, 
	{$rule}.cmsmasters-form-builder .check_parent input[type=checkbox] + label:after, 
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=radio] + span.wpcf7-list-item-label:after, 
	{$rule}.cmsmasters-form-builder .check_parent input[type=radio] + label:after,
	{$rule}#wp-comment-cookies-consent + label:after,
	{$rule}.woocommerce .woocommerce-form__input-checkbox + span:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_border .cmsmasters_icon_list_item .cmsmasters_icon_list_icon:after {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	/* Finish Primary Color */
	
	
	/* Start Highlight Color */
	" . (($scheme == 'default') ? "#slide_top," : '') . "
	{$rule}input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]), 
	{$rule}a:hover,
	{$rule}a.cmsmasters_cat_color:hover,
	{$rule}#page .page-numbers,
	{$rule}.cmsmasters_attach_img .cmsmasters_attach_img_edit a:hover, 
	{$rule}.cmsmasters_attach_img .cmsmasters_attach_img_meta a:hover,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but, 
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li.current a,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li.current a:hover,
	{$rule}.footer_custom_html a:hover,
	{$rule}.page-numbers.prev,
	{$rule}.page-numbers.next,
	{$rule}.cmsmasters_prev_arrow,
	{$rule}.cmsmasters_next_arrow,
	{$rule}textarea,
	{$rule}.form_info,
	{$rule}.wpcf7-form,
	{$rule}select,
	{$rule}option,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_lpr_tabs_cont > a,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_tab.tab_comments li > a:last-of-type,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_tabs_list_item a,
	{$rule}#page .widget .cmsmasters_slider_project_title a,
	{$rule}#page .widget a.cmsmastersLike.active,
	{$rule}.widget_custom_contact_info_entries > span:before, 
	{$rule}.widget_custom_contact_info_entries .adress_wrap:before, 
	{$rule}.cmsmasters_pricing_table .cmsmasters_button,
	{$rule}.feature_icon:before,
	{$rule}.cmsmasters_slider_post_read_more,
	{$rule}.cmsmasters_slider_post_read_more,
	{$rule}.cmsmasters_slider_post_likes .cmsmastersLike.active,
	{$rule}aside.widget a:hover,
	{$rule}.widget_custom_twitter_entries .tweet_time,
	{$rule}.cmsmasters_twitter_wrap .cmsmasters_twitter_item_content a:hover,
	{$rule}#page .widget_nav_menu .menu li a,
	{$rule}.blog .cmsmasters_post_default a.cmsmasters_post_read_more,
	{$rule}.post_nav .cmsmasters_prev_post > a,
	{$rule}.post_nav .cmsmasters_next_post > a,
	{$rule}.cmsmasters_toggles_filter,
	{$rule}.cmsmasters_twitter_wrap .published, 
	{$rule}.cmsmasters_twitter_wrap .twr_icon,
	{$rule}#page .widget_recent_comments li > a,
	{$rule}#page .widget_custom_contact_info_entries a:hover,
	{$rule}#page .widget_recent_entries li a,
	{$rule}.widget_custom_twitter_entries .tweet_text a:hover,
	{$rule}.blog .cmsmasters_post_default a:hover,
	{$rule}.cmsmasters_toggles .cmsmasters_toggles_filter a.current_filter,
	{$rule}.blog.opened-article a:hover,
	{$rule}.owl-buttons > div > span:before,
	{$rule}.blog .cmsmasters_post_default .cmsmastersLike.active,
	{$rule}.blog.opened-article .cmsmastersLike.active,
	{$rule}.blog.opened-article .cmsmasters_comment_item_title a:hover,
	{$rule}.toggles_mode_accordion .cmsmasters_toggle_wrap .cmsmasters_toggle_title a,
	{$rule}.cmsmasters_comment_item_title a:hover,
	{$rule}.blog.opened-article .cmsmasters_comment_info_right > *,
	{$rule}.cmsmasters_comment_info_right > *,
	{$rule}.cmsmasters_social_icon,
	{$rule}.subpage_nav > span {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}

	{$rule}.cmsmasters_button,
	{$rule}.button,
	{$rule}.widget_tag_cloud a:hover,
	{$rule}input[type=submit],
	{$rule}.owl-page:hover,
	{$rule}.cmsmasters_toggles.toggles_mode_accordion .cmsmasters_toggle_plus span,
	{$rule}.cmsmasters_table tr.cmsmasters_table_row_header > th, 
	{$rule}.owl-page.active,
	{$rule}.cmsmasters_profile_horizontal .profile_social_icons_list li a,
	{$rule}.footer_inner .cmsmasters_social_icon:hover {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}
	
	{$rule}input::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}
	
	{$rule}input::-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}
	
	{$rule}textarea::-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}
	
	{$rule}textarea::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_hover']) . "
	}
	
	/* Finish Highlight Color */
	
	
	/* Start Headings Color */
	" . (($scheme == 'default') ? ".headline_outer," : '') . "
	" . (($scheme == 'default') ? ".headline_outer a:hover," : '') . "
	{$rule}h1,
	{$rule}h2,
	{$rule}h3,
	{$rule}h4,
	{$rule}h5,
	{$rule}h6,
	{$rule}h1 a,
	{$rule}h2 a,
	{$rule}h3 a,
	{$rule}h4 a,
	{$rule}h5 a,
	{$rule}h6 a,
	{$rule}#page .widgettitle a,
	{$rule}.blog .cmsmasters_post_default .cmsmasters_post_title,
	{$rule}.blog .cmsmasters_post_default .cmsmasters_post_title a,
	{$rule}.blog.opened-article .cmsmasters_post_header .cmsmasters_post_title ,
	{$rule}.footer_custom_html,
	{$rule}.footer_custom_html a,
	{$rule}fieldset legend,
	{$rule}blockquote footer,
	{$rule}table caption,
	{$rule}.blog .cmsmasters_single_slider_item_title,
	{$rule}.blog .cmsmasters_single_slider_item_title a,
	{$rule}.img_placeholder_small, 
	{$rule}.search_button button, 
	{$rule}.cart_totals .shop_table .amount, 
	{$rule}.cmsmasters_stats.stats_mode_bars.stats_type_horizontal .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner,
	{$rule}.cmsmasters_stats.stats_mode_bars.stats_type_horizontal .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner:before, 
	{$rule}.cmsmasters_stats.stats_mode_bars.stats_type_vertical .cmsmasters_stat_wrap .cmsmasters_stat_title,
	{$rule}.cmsmasters_stats.stats_mode_circles .cmsmasters_stat_wrap .cmsmasters_stat_title, 
	{$rule}.cmsmasters_stats.stats_mode_bars.stats_type_vertical .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner .cmsmasters_stat_title_counter_wrap, 
	{$rule}.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner .cmsmasters_counter_counter_wrap, 
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > a,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > ul > li > a,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > ul > li > ul li a:before,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap_category > li > a,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap_category > li > ul li a:before,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap_archive > li a:before {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_heading']) . "
	}
	
	{$rule}.cmsmasters_icon_list_items .cmsmasters_icon_list_item .cmsmasters_icon_list_icon,
	{$rule}form .formError .formErrorContent {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_heading']) . "
	}
	
	{$rule}form .formError .formErrorContent:before {
		" . cmsmasters_color_css('border-top-color', $cmsmasters_option['kids' . '_' . $scheme . '_heading']) . "
	}
	/* Finish Headings Color */
	
	
	/* Start Main Background Color */
	{$rule}mark,
	{$rule}.cmsmasters_prev_arrow:hover, 
	{$rule}.cmsmasters_next_arrow:hover,
	{$rule}form .formError .formErrorContent,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left_top:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_top:before,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_border .cmsmasters_icon_list_item .cmsmasters_icon_list_icon:before,
	{$rule}.cmsmasters_stats.stats_mode_bars.stats_type_vertical .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_counter_wrap,
	{$rule}input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]):focus,
	{$rule}textarea:focus,
	{$rule}#page .widget .button,
	{$rule}.cmsmasters_button,
	{$rule}.button,
	{$rule}.button:hover,
	{$rule}.cmsmasters_prev_post > a:hover + span,
	{$rule}.cmsmasters_next_post > a:hover + span,
	{$rule}#page .page-numbers.prev:hover,
	{$rule}#page .page-numbers.next:hover,
	{$rule}.owl-buttons > div:hover > span:before,
	{$rule}input[type=submit],
	{$rule}.notice_close,
	{$rule}.pricing_title,
	{$rule}.toggles_mode_toggle .cmsmasters_toggle_wrap,
	{$rule}.toggles_mode_toggle .cmsmasters_toggle_wrap a,
	{$rule}.toggles_mode_toggle .cmsmasters_toggle_wrap a:hover,
	{$rule}.cmsmasters_table tr.cmsmasters_table_row_header > th, 
	{$rule}.cmsmasters_table tr.cmsmasters_table_row_footer > td, 
	{$rule}.cmsmasters_pricing_table .cmsmasters_button:hover,
	{$rule}.cmsmasters_price_wrap,
	{$rule}.cmsmasters_stats.stats_mode_circles .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner .cmsmasters_stat_counter_wrap,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_tabs_list_item.current_tab a,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_tabs_list_item.current_tab a:hover,
	{$rule}.cmsmasters_breadcrumbs_inner,
	{$rule}.cmsmasters_breadcrumbs_inner a,
	{$rule}.cmsmasters_button:hover,
	{$rule}#page .widget_tag_cloud a,
	{$rule}#page .widget_tag_cloud a:hover,
	{$rule}#page .widget .button:hover,
	{$rule}#page .widget_nav_menu .menu li.current_page_item > a,
	{$rule}#page .widget_nav_menu .menu li.current_page_item > a:hover,
	{$rule}.cmsmasters_tabs .cmsmasters_tabs_list_item a,
	{$rule}.cmsmasters_profile_horizontal .profile_social_icons_list li a,
	{$rule}.cmsmasters_social_icon:hover,
	{$rule}.cmsmasters_project_price,
	" . (($scheme == 'default') ? "#slide_top:hover," : '') . "
	{$rule}.cmsmasters_stats.stats_mode_bars.stats_type_vertical .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.bottom_bg,
	{$rule}.cmsmasters_project_puzzle .project_inner,
	{$rule}.cmsmasters_project_puzzle .project_inner a,
	{$rule}.cmsmasters_slider_project_inner,
	{$rule}.cmsmasters_slider_project_inner a,
	{$rule}.cmsmasters_slider_project_inner a:hover,
	{$rule}.cmsmasters_slider_project_inner .cmsmasters_project_details_wrap,
	{$rule}.cmsmasters_slider_post_date,
	{$rule}.cmsmasters_profile_vertical .cmsmasters_profile_title a, 
	{$rule}.cmsmasters_profile_vertical .cmsmasters_profile_title a:hover,
	{$rule}.cmsmasters_profile_vertical .cmsmasters_profile_content, 
	{$rule}.cmsmasters_profile_vertical .cmsmasters_profile_subtitle, 
	{$rule}.cmsmasters_archive_item_date_wrap, 
	{$rule}.cmsmasters_archive_item_date_wrap a, 
	{$rule}.cmsmasters_archive_item_date_wrap a:hover, 
	{$rule}.blog a,
	{$rule}.blog a:hover,
	{$rule}.cmsmasters_post_info,
	{$rule}.cmsmasters_post_date,
	{$rule}.cmsmasters_post_title,
	{$rule}.cmsmasters_post_content,
	{$rule}.cmsmasters_post_read_more,
	{$rule}.cmsmasters_post_author,
	{$rule}.cmsmasters_post_category,
	{$rule}.cmsmasters_post_likes,
	{$rule}.cmsmasters_post_comments {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but:hover,
	.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but {
		background-color:transparent;
	}
	
	
	" . (($scheme != 'default') ? ".cmsmasters_color_scheme_{$scheme}.cmsmasters_footer_default," : '') . "
	" . (($scheme != 'default') ? ".cmsmasters_color_scheme_{$scheme}," : '') . "
	" . (($scheme == 'default') ? "body," : '') . "
	" . (($scheme == 'default') ? ".middle_inner," : '') . "
	{$rule}.footer_bottom, 
	{$rule}.cmsmasters_toggles .cmsmasters_toggle_plus span, 
	{$rule}option, 
	{$rule}.cmsmasters_slider_project .cmsmasters_img_rollover, 
	{$rule}.cmsmasters_project_puzzle .project_inner .cmsmasters_links_wrap > a > span, 
	{$rule}.toggles_mode_accordion .cmsmasters_toggle_title:hover .cmsmasters_toggle_plus span,
	{$rule}.cmsmasters_profile_vertical .cmsmasters_social_icon, 
	{$rule}.cmsmasters_img_rollover > a > span {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}textarea:focus::-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}textarea:focus::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}input:focus::-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}input:focus::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	/* Finish Main Background Color */
	
	
	/* Start Alternate Background Color */
	{$rule}.cmsmasters_dropcap.type2,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_icon .cmsmasters_icon_list_icon_wrap {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . "
	}
	
	
	" . (($scheme == 'default') ? "#slide_top," : '') . "
	" . (($scheme != 'default') ? ".cmsmasters_color_scheme_{$scheme}.cmsmasters_footer_default," : '') . "
	{$rule}select,
	{$rule}.widget_nav_menu ul li a, 
	{$rule}.cmsmasters_prev_arrow, 
	{$rule}.cmsmasters_next_arrow,
	{$rule}.img_placeholder_small, 
	{$rule}.img_placeholder, 
	{$rule}.cmsmasters_featured_block,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li.current a,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_top,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_icon .cmsmasters_icon_list_icon,
	{$rule}.cmsmasters_stats.stats_mode_circles .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner, 
	{$rule}.gallery-item .gallery-icon,
	{$rule}.gallery-item .gallery-caption,
	{$rule}.cmsmasters_img.with_caption, 
	{$rule}#page .page-numbers.prev,
	{$rule}#page .page-numbers.next,
	{$rule}.about_author_inner,
	{$rule}.owl-buttons > div,
	{$rule}.cmsmasters_post_commlike_info,
	{$rule}.cmsmasters_comment_item_content,
	{$rule}input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]),
	{$rule}textarea,
	{$rule}.puzzle_post_img_wrap,
	{$rule}.cmsmasters_social_icon,
	{$rule}.owl-page,
	{$rule}.widgettitle,
	{$rule}.cmsmasters_archive_item_type,
	{$rule}.widget_custom_contact_info_entries > span:before, 
	{$rule}.widget_custom_contact_info_entries .adress_wrap:before, 
	{$rule}.widget ul li a:before,
	{$rule}.cmsmasters_toggles.toggles_mode_accordion .cmsmasters_toggle_plus,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quote_inner,
	{$rule}.cmsmasters_profile_vertical .cmsmasters_social_icon:hover,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_tabs_list_item a, 
	{$rule}.profile_details_title, 
	{$rule}.project_details_title, 
	{$rule}.project_features_title, 
	{$rule}.profile_features_title, 
	{$rule}.profile_social_icons_title, 
	{$rule}.cmsmasters_pricing_table .cmsmasters_button,
	{$rule}.cmsmasters_pricing_item_cont_wrap,
	{$rule}.cmsmasters_stats.stats_mode_bars.stats_type_horizontal .cmsmasters_stat_wrap:before,
	{$rule}.cmsmasters_stats.stats_mode_bars .cmsmasters_stat_wrap .cmsmasters_stat_container,
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=checkbox] + span.wpcf7-list-item-label:before, 
	{$rule}.cmsmasters-form-builder .check_parent input[type=checkbox] + label:before, 
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=radio] + span.wpcf7-list-item-label:before, 
	{$rule}.cmsmasters-form-builder .check_parent input[type=radio] + label:before,
	{$rule}#wp-comment-cookies-consent + label:before,
	{$rule}.woocommerce .woocommerce-form__input-checkbox + span:before {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . "
	}
	
	{$rule}.cmsmasters_profile_horizontal .pl_im_wrap .profile_social_icons:hover {
		background-color:rgba(" . color2rgb($cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . ", 0.9);
	}
	
	
	{$rule}.footer_bottom:before {
		background-image: -webkit-gradient(linear, 0 0, 300% 100%, color-stop(0.25, " . $cmsmasters_option['kids' . '_' . $scheme . '_alternate'] . "), color-stop(0.25, " . $cmsmasters_option['kids' . '_' . $scheme . '_alternate'] . "));
		background-image: linear-gradient(135deg, " . $cmsmasters_option['kids' . '_' . $scheme . '_alternate'] . " 25%, transparent 25%), linear-gradient(225deg, " . $cmsmasters_option['kids' . '_' . $scheme . '_alternate'] . " 25%, transparent 25%);
	}
	
	
	
	{$rule}.cmsmasters_comment_item_cont .cmsmasters_comment_item_content:before {
		" . cmsmasters_color_css('border-right-color', $cmsmasters_option['kids' . '_' . $scheme . '_alternate']) . "
	}
	
	/* Finish Alternate Background Color */
	
	
	/* Start Borders Color */
	{$rule}.blog.timeline:before,
	{$rule}.footer_inner .cmsmasters_social_icon,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li:before {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_border']) . "
	}
	
	" . (($scheme == 'default') ? ".headline_outer," : '') . "
	{$rule}.cmsmasters_attach_img .cmsmasters_attach_img_info, 
	{$rule}option,
	{$rule}hr,
	{$rule}.cmsmasters_profile_header,
	{$rule}.cmsmasters_project_header,
	{$rule}.cmsmasters_divider,
	{$rule}.cmsmasters_table tbody tr,
	{$rule}.cmsmasters_widget_divider,
	{$rule}.cmsmasters_img.with_caption,
	{$rule}.cmsmasters_icon_wrap .cmsmasters_simple_icon, 
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_top,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_icon_list_type_block .cmsmasters_icon_list_item,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_bg .cmsmasters_icon_list_icon:after,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_icon .cmsmasters_icon_list_icon:after, 
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=checkbox] + span.wpcf7-list-item-label:before, 
	{$rule}.cmsmasters-form-builder .check_parent input[type=checkbox] + label:before, 
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=radio] + span.wpcf7-list-item-label:before, 
	{$rule}.cmsmasters-form-builder .check_parent input[type=radio] + label:before,
	{$rule}#wp-comment-cookies-consent + label:before,
	{$rule}.woocommerce .woocommerce-form__input-checkbox + span:before,
	{$rule}table,
	{$rule}table td,
	{$rule}table th,
	{$rule}table tr {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_border']) . "
	}
	/* Finish Borders Color */
	
	/* Start Secondary Color */
	{$rule}h1 a:hover,
	{$rule}h2 a:hover,
	{$rule}h3 a:hover,
	{$rule}h4 a:hover,
	{$rule}h5 a:hover,
	{$rule}h6 a:hover,
	{$rule}.search_button button:hover,
	{$rule}.project_details_item.price .project_details_item_desc,
	{$rule}#page .widgettitle a:hover,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_lpr_tabs_cont > a:hover,
	{$rule}#page .widget_nav_menu .menu li a:hover,
	{$rule}.widget_calendar thead,
	{$rule}.widget_custom_twitter_entries .tweet_text a,
	{$rule}.toggles_mode_accordion .cmsmasters_toggle_wrap .cmsmasters_toggle_title a:hover,
	{$rule}.cmsmasters_profile_vertical .cmsmasters_social_icon,
	{$rule}.cmsmasters_profile_vertical .cmsmasters_social_icon:hover,
	{$rule}#page .page-numbers.current,
	{$rule}.cmsmasters_archive_item_title a:hover,
	{$rule}#page .widget_recent_comments li > a:hover,
	{$rule}#page .widget .cmsmasters_slider_project_title a:hover,
	{$rule}#page .widget_custom_contact_info_entries a,
	{$rule}.cmsmasters_puzzle_type .preloader span,
	{$rule}.cmsmasters_slider_post_title a:hover,
	{$rule}.cmsmasters_slider_post_read_more:hover,
	{$rule}.cmsmasters_img_rollover_wrap .img_placeholder,
	{$rule}.cmsmasters_img_rollover > a > span,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_tab.tab_comments li > a:last-of-type:hover,
	{$rule}.cmsmasters_project_grid .project_details_item,
	{$rule}.blog .cmsmasters_single_slider_item_title a:hover,
	{$rule}.blog .cmsmasters_post_default a.cmsmasters_post_read_more:hover,
	{$rule}.blog .cmsmasters_post_default .cmsmasters_post_title a:hover,
	{$rule}.blog .cmsmasters_comment_info_right a:hover,
	{$rule}.cmsmasters_project_puzzle .project_inner .cmsmasters_links_wrap > a > span,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_tabs_list_item a:hover,
	{$rule}.cmsmasters_comment_info_right a:hover,
	{$rule}.cmsmasters_twitter_wrap .cmsmasters_twitter_item_content a,
	{$rule}#page .widget_recent_entries li a:hover,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but:hover,
	{$rule}.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner .cmsmasters_counter_title, 
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li a:hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	" . (($scheme == 'default') ? "#slide_top:hover," : '') . "
	{$rule}.cmsmasters_prev_arrow:hover, 
	{$rule}.cmsmasters_next_arrow:hover,
	{$rule}.cmsmasters_button:hover,
	{$rule}.button:hover,
	{$rule}input[type=submit]:hover,
	{$rule}#page .page-numbers.prev:hover,
	{$rule}#page .page-numbers.next:hover,
	{$rule}.cmsmasters_social_icon:hover,
	{$rule}.cmsmasters_slider_post_date,
	{$rule}.cmsmasters_post_cont,
	{$rule}.cmsmasters_post_date,
	{$rule}.cmsmasters_post_timeline .cmsmasters_post_cont_info_wrap,
	{$rule}.cmsmasters_puzzle_type .cmsmasters_post_footer,
	{$rule}.cmsmasters_img_rollover,
	{$rule}.owl-buttons > div:hover,
	{$rule}.cmsmasters_prev_post > a:hover + span,
	{$rule}.cmsmasters_next_post > a:hover + span,
	{$rule}textarea:focus,
	{$rule}.widget_tag_cloud a,
	{$rule}#page .widget_custom_posts_tabs_entries .cmsmasters_tabs_list_item.current_tab a, 
	{$rule}.toggles_mode_accordion .cmsmasters_toggle_title:hover .cmsmasters_toggle_plus, 
	{$rule}.toggles_mode_toggle .cmsmasters_toggle_wrap, 
	{$rule}.cmsmasters_tabs .cmsmasters_tabs_list_item a, 
	{$rule}.cmsmasters_table tr.cmsmasters_table_row_footer > td, 
	{$rule}.cmsmasters_profile_horizontal .profile_social_icons_list li a:hover, 
	{$rule}.cmsmasters_profile_vertical .profile_outer, 
	{$rule}.cmsmasters_pricing_table .cmsmasters_button:hover, 
	{$rule}.cmsmasters_pricing_item_cont_inner, 
	{$rule}.cmsmasters_project_price, 
	{$rule}.cmsmasters_archive_type .cmsmasters_archive_item_date_wrap, 
	{$rule}.cmsmasters_slider_project_inner,
	{$rule}#page .widget_nav_menu .menu li.current_page_item > a, 
	{$rule}.cmsmasters_hover_slider .cmsmasters_hover_slider_thumbs a:before, 
	{$rule}input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]):focus,
	{$rule}#page ~ .datepicker table .active {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	{$rule}.cmsmasters_tabs.tabs_mode_tab .cmsmasters_tabs_list_item:before,
	{$rule}.blog .post.cmsmasters_puzzle_type:nth-child(even) .puzzle_post_content_wrapper:before {
		" . cmsmasters_color_css('border-top-color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	{$rule}.cmsmasters_tabs.tabs_mode_tour.tabs_pos_left .cmsmasters_tabs_list_item:before {
		" . cmsmasters_color_css('border-left-color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	{$rule}.blog .post.cmsmasters_puzzle_type:nth-child(odd) .puzzle_post_content_wrapper:before {
		" . cmsmasters_color_css('border-bottom-color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	{$rule}.cmsmasters_tabs.tabs_mode_tour.tabs_pos_right .cmsmasters_tabs_list_item:before {
		" . cmsmasters_color_css('border-right-color', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
	}
	
	/* Finish Secondary Color */
	
	/* Start Custom Rules */
	{$rule}.widget .cmsmasters_slider_project_inner,
	{$rule}.blog .cmsmasters_post_default .cmsmasters_post_cont,
	{$rule}.blog .cmsmasters_post_timeline .cmsmasters_post_cont,
	{$rule}.blog.columns .cmsmasters_post_date {
		background:transparent !important;
	}
	
	{$rule}::selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . ";
	}
	
	{$rule}::-moz-selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['kids' . '_' . $scheme . '_secondary']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	";
	
	
	$custom_css .= "
	/* Finish Custom Rules */

/***************** Finish {$title} Color Scheme Rules ******************/


/***************** Start {$title} Button Color Scheme Rules ******************/
	
	{$rule}.cmsmasters_button.cmsmasters_but_bg_hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_bg_hover:hover, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_bg_hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_left, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_right, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_top, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_bottom, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_vert, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_hor, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_diag {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_left:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_right:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_top:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_bottom:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_vert:hover, 
	{$rule}.cmsmasters_button.cm.sms_but_bg_expand_hor:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_diag:hover, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_bg_slide_left, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_bg_slide_right, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_bg_slide_top, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_bg_slide_bottom, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_bg_expand_vert, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_bg_expand_hor, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_bg_expand_diag {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_left:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_right:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_top:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_bottom:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_vert:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_hor:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_diag:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_shadow {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_shadow:hover, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_shadow {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_dark_bg, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_light_bg, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_divider {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_dark_bg:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_light_bg:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_divider:hover, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_dark_bg, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_light_bg, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_divider {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_divider:after {
		" . cmsmasters_color_css('border-right-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse:before {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse:hover, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_inverse {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse:hover:before, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_inverse:before {
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse:hover:after, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_inverse:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_slide_left, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_slide_right {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_slide_left:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_slide_right:hover, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_slide_left, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_slide_right {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_left, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_right, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_top, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_bottom {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_left:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_right:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_top:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_bottom:hover, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_hover_slide_left, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_hover_slide_right, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_hover_slide_top, 
	{$rule}.cmsmasters_paypal_donations > form:hover + .cmsmasters_button.cmsmasters_but_icon_hover_slide_bottom {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['kids' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['kids' . '_' . $scheme . '_bg']) . "
	}

/***************** Finish {$title} Button Color Scheme Rules ******************/


";
	}
	
	
	return apply_filters('kids_theme_colors_primary_filter', $custom_css);
}

