<?php 
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version		1.1.4
 * 
 * Template Functions for Blog & Post
 * Created by CMSMasters
 * 
 */


/* Get Posts Hightlight Function */
function kids_post_color($cmsmasters_id, $post_format, $layout_type = 'default', $show = true) {
	$cmsmasters_post_color = get_post_meta($cmsmasters_id, 'cmsmasters_post_color', true);
	
	if ($cmsmasters_post_color !='') {
		$out = '<style type="text/css">';
			if ($layout_type == 'timeline') {
				$out .= '#post-' . $cmsmasters_id . ' .cmsmasters_post_cont_info_wrap, ' . 
					'#post-' . $cmsmasters_id . ' .cmsmasters_post_date {' . 
					'background-color:' . $cmsmasters_post_color . ';' . 
				'}';
			}
			
			if ($layout_type == 'archive') {
				$out .= '#post-' . $cmsmasters_id . ' .cmsmasters_archive_item_date_wrap {' . 
					'background-color:' . $cmsmasters_post_color . ';' . 
				'}';
			}
			
			if ($layout_type == 'default') {
				$out .= '#post-' . $cmsmasters_id . ' .cmsmasters_post_date {' . 
					'background-color:' . $cmsmasters_post_color . ';' . 
				'}';
			}
			
			if ($layout_type == 'masonry') {
				$out .= '#post-' . $cmsmasters_id . ' .cmsmasters_post_cont {' . 
					'background-color:' . $cmsmasters_post_color . ';' . 
				'}';
			}
			
			if ($layout_type == 'puzzle') {
				$out .= '#post-' . $cmsmasters_id . ' .cmsmasters_post_cont, ' .
					'#post-' . $cmsmasters_id . ' .cmsmasters_post_footer {' .
					'background-color:' . $cmsmasters_post_color . ';' . 
				'}';
				
				$out .= '#post-' . $cmsmasters_id . '.cmsmasters_puzzle_type:nth-child(odd) .puzzle_post_content_wrapper:before {' . 
					'border-bottom-color:' . $cmsmasters_post_color . ';' . 
				'}';
				
				$out .= '#post-' . $cmsmasters_id . '.cmsmasters_puzzle_type:nth-child(even) .puzzle_post_content_wrapper:before {' . 
					'border-top-color:' . $cmsmasters_post_color . ';' . 
				'}';
				
				$out .= '#post-' . $cmsmasters_id . ' .preloader span {' . 
					'color:' . $cmsmasters_post_color . ';' . 
				'}';
			}
			
			if ($layout_type == 'post') {
				$out .= '#post-' . $cmsmasters_id . ' .cmsmasters_post_date {' . 
					'background-color:' . $cmsmasters_post_color . ';' . 
				'}';
			}
			
			if ($layout_type == 'post_slider') {
				$out .= '#post-' . $cmsmasters_id . ' .cmsmasters_slider_post_date {' . 
					'background-color:' . $cmsmasters_post_color . ';' . 
				'}';
				
				$out .= '#post-' . $cmsmasters_id . ' .img_placeholder:before {' . 
					'color:' . $cmsmasters_post_color . ';' . 
				'}';
			}
		$out .= '</style>';
		
		if ($show) {
			echo kids_return_content($out);
		} else {
			return $out;
		}
	}
}

/* Get Posts Heading Function */
function kids_post_heading($cmsmasters_id, $tag = 'h1', $show = true) {
	$out = '';
	
	if (cmsmasters_title($cmsmasters_id, false) != $cmsmasters_id) {
		$out = '<header class="cmsmasters_post_header entry-header">' . 
			'<' . esc_html($tag) . ' class="cmsmasters_post_title entry-title">' . 
				'<a href="' . esc_url(get_permalink()) . '">' . cmsmasters_title($cmsmasters_id, false) . '</a>' . 
			'</' . esc_html($tag) . '>' . 
		'</header>';
	}
	
	
	if ($show) {
		echo wp_kses_post($out);
	} else {
		return wp_kses_post($out);
	}
}



/* Get Posts Heading Without Link Function */
function kids_post_title_nolink($cmsmasters_id, $tag = 'h1', $show = true) { 
	$out = '';
	

	if (cmsmasters_title($cmsmasters_id, false) != $cmsmasters_id) {
		$out = '<header class="cmsmasters_post_header entry-header">' . 
			'<' . esc_html($tag) . ' class="cmsmasters_post_title entry-title">' . 
				esc_html(strip_tags(get_the_title($cmsmasters_id) ? get_the_title($cmsmasters_id) : $cmsmasters_id)) . 
			'</' . esc_html($tag) . '>' . 
		'</header>';
	}
	
	if ($show) {
		echo wp_kses_post($out);
	} else {
		return wp_kses_post($out);
	}
}



/* Get Posts Date Function */
function kids_get_post_date($template_type = 'page', $layout_type = 'default', $show = true) {
	if ($template_type == 'page') {
		if ($layout_type == 'masonry') {
			$out = '<span class="cmsmasters_post_date">' . 
				'<abbr class="published" title="' . esc_attr(get_the_date()) . '">' . 
					esc_html__('On', 'kids') . ' ' . 
					'<span class="cmsmasters_day_mon">' . esc_html(get_the_date('d M Y')) . '</span>' . 
				'</abbr>' . 
				'<abbr class="dn date updated" title="' . esc_attr(get_the_modified_date()) . '">' . 
					esc_html(get_the_modified_date()) . 
				'</abbr>' . 
			'</span>';
		} else {
			$out = '<span class="cmsmasters_post_date">' . 
				'<abbr class="published" title="' . esc_attr(get_the_date()) . '">' . 
					'<span class="cmsmasters_day_mon">' . esc_html(get_the_date('d M')) . '</span>' . 
					'<span class="cmsmasters_year">' . esc_html(get_the_date('Y')) . '</span>' . 
				'</abbr>' . 
				'<abbr class="dn date updated" title="' . esc_attr(get_the_modified_date()) . '">' . 
					esc_html(get_the_modified_date()) . 
				'</abbr>' . 
			'</span>';
		}
		
		if (cmsmasters_title(get_the_ID(), false) == get_the_ID()) {
			$out = '<a href="' . esc_url(get_permalink()) . '">' . $out . '</a>';
		}
	} elseif ($template_type == 'post') {
		$cmsmasters_option = kids_get_global_options();
		
		$out = '';
		
		if ($cmsmasters_option['kids' . '_blog_post_date']) {
			$out .= '<span class="cmsmasters_post_date">' . 
				'<abbr class="published" title="' . esc_attr(get_the_date()) . '">' . 
					'<span class="cmsmasters_day_mon">' . esc_html(get_the_date('d M')) . '</span>' . 
					'<span class="cmsmasters_year">' . esc_html(get_the_date('Y')) . '</span>' . 
				'</abbr>' . 
				'<abbr class="dn date updated" title="' . esc_attr(get_the_modified_date()) . '">' . 
					esc_html(get_the_modified_date()) . 
				'</abbr>' . 
			'</span>';
		}
	}
	
	
	if ($show) {
		echo wp_kses_post($out);
	} else {
		return wp_kses_post($out);
	}
}



/* Get Posts Author Function */
function kids_get_post_author($template_type = 'page', $show = true) {
	if ($template_type == 'page') {
		$out = '<span class="cmsmasters_post_author">' . 
			esc_html__('By', 'kids') . ' ' . 
			'<a href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '" title="' . esc_attr__('Posts by', 'kids') . ' ' . esc_attr(get_the_author_meta('display_name')) . '" class="vcard author">' . 
				'<span class="fn">' . esc_html(get_the_author_meta('display_name')) . '</span>' . 
			'</a>' . 
		'</span>';
	} elseif ($template_type == 'post') {
		$cmsmasters_option = kids_get_global_options();
		$out = '';
		
		if ($cmsmasters_option['kids' . '_blog_post_author']) {
			$out .= '<span class="cmsmasters_post_author">' . 
				esc_html__('By', 'kids') . ' ' . 
				'<a href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '" title="' . esc_attr__('Posts by', 'kids') . ' ' . esc_attr(get_the_author_meta('display_name')) . '" class="vcard author">' . 
					'<span class="fn">' . esc_html(get_the_author_meta('display_name')) . '</span>' . 
				'</a>' . 
			'</span>';
		}
	}
	
	
	if ($show) {
		echo wp_kses_post($out);
	} else {
		return wp_kses_post($out);
	}
}



/* Get Posts Category Function */
function kids_get_post_category($cmsmasters_id, $taxonomy, $template_type = 'page', $show = true) {
	$out = '';
	
	
	if (get_the_terms($cmsmasters_id, $taxonomy)) {
		if ($template_type == 'page') {
			$out .= '<span class="cmsmasters_post_category">' . 
				esc_html__('In', 'kids') . ' ' . 
				kids_get_the_category_list($cmsmasters_id, $taxonomy, ', ') . 
			'</span>';
		} elseif ($template_type == 'post') {
			$cmsmasters_option = kids_get_global_options();
			
			
			if ($cmsmasters_option['kids' . '_blog_post_cat']) {
				$out .= '<span class="cmsmasters_post_category">' . 
					esc_html__('In', 'kids') . ' ' . 
					kids_get_the_category_list($cmsmasters_id, $taxonomy, ', ') . 
				'</span>';
			}
		}
	}
	
	
	if ($show) {
		echo wp_kses_post($out);
	} else {
		return wp_kses_post($out);
	}
}



/* Get Posts Tags Function */
function kids_get_post_tags($show = true) {
	if (get_the_tags()) {
		$cmsmasters_option = kids_get_global_options();
		$out = '';
		
		if ($cmsmasters_option['kids' . '_blog_post_tag']) {
			$out .= '<span class="cmsmasters_post_tags">' . 
				get_the_tag_list(esc_html__('Tags', 'kids') . ': ', ', ', '') . 
			'</span>';
		}
		
		
		if ($show) {
			echo wp_kses_post($out);
		} else {
			return wp_kses_post($out);
		}
	}
}



/* Get Posts Content/Excerpt Function */
function kids_post_exc_cont($show = true) {
	$out = cmsmasters_divpdel('<div class="cmsmasters_post_content entry-content">' . "\n" . 
		wpautop(theme_excerpt(20, false)) . 
	'</div>' . "\n");
	
	
	if (theme_excerpt(20, false) != '') {
		if ($show) {
			echo kids_return_content($out);
		} else {
			return $out;
		}
	}
}



/* Get Posts Like Function */
function kids_get_post_likes($template_type = 'page', $show = true) {
	$out = '';
	
	
	if ($template_type == 'page') {
		$out = cmsmasters_Like('cmsmasters_post_likes');
	} elseif ($template_type == 'post') {
		$cmsmasters_option = kids_get_global_options();
		
		if ($cmsmasters_option['kids' . '_blog_post_like']) {
			$out = cmsmasters_Like('cmsmasters_post_likes');
		}
	}
	
	
	if ($show) {
		echo kids_return_content($out);
	} else {
		return $out;
	}
}



/* Get Posts Comments Function */
function kids_get_post_comments($template_type = 'page', $show = true) {
	$out = '';
	
	
	if (comments_open()) {
		if ($template_type == 'page') {
			$out = kids_get_comments('cmsmasters_post_comments');
		} elseif ($template_type == 'post') {
			$cmsmasters_option = kids_get_global_options();
			
			if ($cmsmasters_option['kids' . '_blog_post_comment']) {
				$out = kids_get_comments('cmsmasters_post_comments');
			}
		}
	}
	
	
	if ($show) {
		echo kids_return_content($out);
	} else {
		return $out;
	}
}



/* Get Posts More Button/Link Function */
function kids_post_more($cmsmasters_id, $show = true) {
	$cmsmasters_post_read_more = get_post_meta($cmsmasters_id, 'cmsmasters_post_read_more', true);
	
	
	if ($cmsmasters_post_read_more == '') {
		$cmsmasters_post_read_more = esc_html__('Read More', 'kids');
	}
	
	
	$out = '<a class="cmsmasters_post_read_more" href="' . esc_url(get_permalink($cmsmasters_id)) . '">' . esc_html($cmsmasters_post_read_more) . '</a>';
	
	
	if ($show) {
		echo wp_kses_post($out);
	} else {
		return wp_kses_post($out);
	}
}



/* Get Post Format Icon Placeholder Function */
function kids_post_format_icon_placeholder($cmsmasters_id, $format = 'std', $show = true) {
	$out = '<figure>' . 
		'<a href="' . esc_url(get_permalink()) . '" title="' . cmsmasters_title($cmsmasters_id, false) . '" class="preloader cmsmasters_theme_icon_' . esc_attr($format) . '"></a>' . 
	'</figure>';
	
	
	if ($show) {
		echo wp_kses_post($out);
	} else {
		return wp_kses_post($out);
	}
}

