<?php 
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version		1.0.0
 * 
 * Admin Panel Post, Project, Profile & Donations Campaign Settings
 * Created by CMSMasters
 * 
 */


function kids_options_single_tabs() {
	$tabs = array();
	
	
	$tabs['post'] = esc_attr__('Post', 'kids');
	
	if (CMSMASTERS_PROJECT_COMPATIBLE && class_exists('Cmsmasters_Projects')) {
		$tabs['project'] = esc_attr__('Project', 'kids');
	}
	
	if (CMSMASTERS_PROFILE_COMPATIBLE && class_exists('Cmsmasters_Profiles')) {
		$tabs['profile'] = esc_attr__('Profile', 'kids');
	}
	
	if (CMSMASTERS_DONATIONS) {
		$tabs['campaign'] = esc_attr__('Campaign', 'kids');
	}
	
	if (CMSMASTERS_TIMETABLE) {
		$tabs['tt_event'] = esc_attr__('Timetable Event', 'kids');
	}
	
	return $tabs;
}


function kids_options_single_sections() {
	$tab = kids_get_the_tab();
	
	
	switch ($tab) {
	case 'post':
		$sections = array();
		
		$sections['post_section'] = esc_attr__('Blog Post Options', 'kids');
		
		
		break;
	case 'project':
		$sections = array();
		
		$sections['project_section'] = esc_attr__('Portfolio Project Options', 'kids');
		
		
		break;
	case 'profile':
		$sections = array();
		
		$sections['profile_section'] = esc_attr__('Person Block Profile Options', 'kids');
		
		
		break;
	case 'campaign':
		$sections = array();
		
		$sections['campaign_section'] = esc_attr__('Donations Campaign Options', 'kids');
		
		
		break;
	case 'tt_event':
		$sections = array();
		
		$sections['tt_event_section'] = esc_attr__('Timetable Event Options', 'kids');
		
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	
	return $sections;
} 


function kids_options_single_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = kids_get_the_tab();
	}
	
	
	$options = array();
	
	
	switch ($tab) {
	case 'post':
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_layout', 
			'title' => esc_html__('Layout Type', 'kids'), 
			'desc' => '', 
			'type' => 'radio_img', 
			'std' => 'r_sidebar', 
			'choices' => array( 
				esc_html__('Right Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_title', 
			'title' => esc_html__('Post Title', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_date', 
			'title' => esc_html__('Post Date', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_cat', 
			'title' => esc_html__('Post Categories', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_author', 
			'title' => esc_html__('Post Author', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_comment', 
			'title' => esc_html__('Post Comments', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_tag', 
			'title' => esc_html__('Post Tags', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_like', 
			'title' => esc_html__('Post Likes', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_nav_box', 
			'title' => esc_html__('Posts Navigation Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_share_box', 
			'title' => esc_html__('Sharing Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_post_author_box', 
			'title' => esc_html__('About Author Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_more_posts_box', 
			'title' => esc_html__('More Posts Box', 'kids'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => 'popular', 
			'choices' => array( 
				esc_html__('Show Related Posts', 'kids') . '|related', 
				esc_html__('Show Popular Posts', 'kids') . '|popular', 
				esc_html__('Show Recent Posts', 'kids') . '|recent', 
				esc_html__('Hide More Posts Box', 'kids') . '|hide' 
			) 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_more_posts_count', 
			'title' => esc_html__('More Posts Box Items Number', 'kids'), 
			'desc' => esc_html__('posts', 'kids'), 
			'type' => 'number', 
			'std' => '3', 
			'min' => '2', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'kids' . '_blog_more_posts_pause', 
			'title' => esc_html__('More Posts Slider Pause Time', 'kids'), 
			'desc' => esc_html__("in seconds, if '0' - autoslide disabled", 'kids'), 
			'type' => 'number', 
			'std' => '1', 
			'min' => '0', 
			'max' => '20' 
		);
		
		
		break;
	case 'project':
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_title', 
			'title' => esc_html__('Project Title', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_details_title', 
			'title' => esc_html__('Project Details Title', 'kids'), 
			'desc' => esc_html__('Enter a project details block title', 'kids'), 
			'type' => 'text', 
			'std' => 'Project details', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_date', 
			'title' => esc_html__('Project Date', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_cat', 
			'title' => esc_html__('Project Categories', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_author', 
			'title' => esc_html__('Project Author', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_comment', 
			'title' => esc_html__('Project Comments', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_tag', 
			'title' => esc_html__('Project Tags', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_like', 
			'title' => esc_html__('Project Likes', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_link', 
			'title' => esc_html__('Project Link', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_share_box', 
			'title' => esc_html__('Sharing Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_nav_box', 
			'title' => esc_html__('Projects Navigation Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_author_box', 
			'title' => esc_html__('About Author Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_more_projects_box', 
			'title' => esc_html__('More Projects Box', 'kids'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => 'popular', 
			'choices' => array( 
				esc_html__('Show Related Projects', 'kids') . '|related', 
				esc_html__('Show Popular Projects', 'kids') . '|popular', 
				esc_html__('Show Recent Projects', 'kids') . '|recent', 
				esc_html__('Hide More Projects Box', 'kids') . '|hide' 
			) 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_more_projects_count', 
			'title' => esc_html__('More Projects Box Items Number', 'kids'), 
			'desc' => esc_html__('projects', 'kids'), 
			'type' => 'number', 
			'std' => '4', 
			'min' => '2', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_more_projects_pause', 
			'title' => esc_html__('More Projects Slider Pause Time', 'kids'), 
			'desc' => esc_html__("in seconds, if '0' - autoslide disabled", 'kids'), 
			'type' => 'number', 
			'std' => '1', 
			'min' => '0', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_project_slug', 
			'title' => esc_html__('Project Slug', 'kids'), 
			'desc' => esc_html__('Enter a page slug that should be used for your projects single item', 'kids'), 
			'type' => 'text', 
			'std' => 'project', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_pj_categs_slug', 
			'title' => esc_html__('Project Categories Slug', 'kids'), 
			'desc' => esc_html__('Enter page slug that should be used on projects categories archive page', 'kids'), 
			'type' => 'text', 
			'std' => 'pj-categs', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'kids' . '_portfolio_pj_tags_slug', 
			'title' => esc_html__('Project Tags Slug', 'kids'), 
			'desc' => esc_html__('Enter page slug that should be used on projects tags archive page', 'kids'), 
			'type' => 'text', 
			'std' => 'pj-tags', 
			'class' => '' 
		);
		
		
		break;
	case 'profile':
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'kids' . '_profile_post_title', 
			'title' => esc_html__('Profile Title', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'kids' . '_profile_post_details_title', 
			'title' => esc_html__('Profile Details Title', 'kids'), 
			'desc' => esc_html__('Enter a profile details block title', 'kids'), 
			'type' => 'text', 
			'std' => 'Profile details', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'kids' . '_profile_post_cat', 
			'title' => esc_html__('Profile Categories', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'kids' . '_profile_post_comment', 
			'title' => esc_html__('Profile Comments', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'kids' . '_profile_post_like', 
			'title' => esc_html__('Profile Likes', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'kids' . '_profile_post_nav_box', 
			'title' => esc_html__('Profiles Navigation Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'kids' . '_profile_post_share_box', 
			'title' => esc_html__('Sharing Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'kids' . '_profile_post_slug', 
			'title' => esc_html__('Profile Slug', 'kids'), 
			'desc' => esc_html__('Enter a page slug that should be used for your profiles single item', 'kids'), 
			'type' => 'text', 
			'std' => 'profile', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'kids' . '_profile_pl_categs_slug', 
			'title' => esc_html__('Profile Categories Slug', 'kids'), 
			'desc' => esc_html__('Enter page slug that should be used on profiles categories archive page', 'kids'), 
			'type' => 'text', 
			'std' => 'pl-categs', 
			'class' => '' 
		);
		
		
		break;
	case 'campaign':
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_layout', 
			'title' => esc_html__('Layout Type', 'kids'), 
			'desc' => '', 
			'type' => 'radio_img', 
			'std' => 'r_sidebar', 
			'choices' => array( 
				esc_html__('Right Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_title', 
			'title' => esc_html__('Campaign Title', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_date', 
			'title' => esc_html__('Campaign Date', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_cat', 
			'title' => esc_html__('Campaign Categories', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_author', 
			'title' => esc_html__('Campaign Author', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_comment', 
			'title' => esc_html__('Campaign Comments', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_tag', 
			'title' => esc_html__('Campaign Tags', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_like', 
			'title' => esc_html__('Campaign Likes', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_nav_box', 
			'title' => esc_html__('Campaign Navigation Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_share_box', 
			'title' => esc_html__('Sharing Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_author_box', 
			'title' => esc_html__('About Author Box', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_more_campaigns_box', 
			'title' => esc_html__('More Campaigns Box', 'kids'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => 'related', 
			'choices' => array( 
				esc_html__('Show Related Campaigns', 'kids') . '|related', 
				esc_html__('Show Popular Campaigns', 'kids') . '|popular', 
				esc_html__('Show Recent Campaigns', 'kids') . '|recent', 
				esc_html__('Hide More Campaigns Box', 'kids') . '|hide' 
			) 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_more_campaigns_count', 
			'title' => esc_html__('More Campaigns Box Items Number', 'kids'), 
			'desc' => esc_html__('campaigns', 'kids'), 
			'type' => 'number', 
			'std' => '3', 
			'min' => '2', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_more_campaigns_pause', 
			'title' => esc_html__('More Campaigns Slider Pause Time', 'kids'), 
			'desc' => esc_html__("in seconds, if '0' - autoslide disabled", 'kids'), 
			'type' => 'number', 
			'std' => '0', 
			'min' => '0', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'campaign_section', 
			'id' => 'kids' . '_donations_campaign_slug', 
			'title' => esc_html__('Campaign Slug', 'kids'), 
			'desc' => esc_html__('Enter a page slug that should be used for your donations campaign single item', 'kids'), 
			'type' => 'text', 
			'std' => 'campaign', 
			'class' => '' 
		);
		
		
		break;
	case 'tt_event':
		$options[] = array( 
			'section' => 'tt_event_section', 
			'id' => 'kids' . '_tt_event_hours', 
			'title' => esc_html__('Event Hours', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'tt_event_section', 
			'id' => 'kids' . '_tt_event_hours_title', 
			'title' => esc_html__('Event Hours Title', 'kids'), 
			'desc' => esc_html__('Enter a event hours block title', 'kids'), 
			'type' => 'text', 
			'std' => 'Event Hours', 
			'class' => ''
		);
		
		$options[] = array( 
			'section' => 'tt_event_section', 
			'id' => 'kids' . '_tt_event_details_title', 
			'title' => esc_html__('Event Details Title', 'kids'), 
			'desc' => esc_html__('Enter a event details block title', 'kids'), 
			'type' => 'text', 
			'std' => 'Event Details', 
			'class' => ''
		);
		
		$options[] = array( 
			'section' => 'tt_event_section', 
			'id' => 'kids' . '_tt_event_cat', 
			'title' => esc_html__('Event Categories', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		
		break;
	}
	
	
	return $options;
}

