<?php 
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version 	1.1.5
 * 
 * Admin Panel General Options
 * Created by CMSMasters
 * 
 */


function kids_options_general_tabs() {
	$cmsmasters_option = kids_get_global_options();
	
	$tabs = array();
	
	$tabs['general'] = esc_attr__('General', 'kids');
	
	if ($cmsmasters_option['kids' . '_theme_layout'] === 'boxed') {
		$tabs['bg'] = esc_attr__('Background', 'kids');
	}
	
	$tabs['header'] = esc_attr__('Header', 'kids');
	$tabs['content'] = esc_attr__('Content', 'kids');
	$tabs['footer'] = esc_attr__('Footer', 'kids');
	
	return $tabs;
}


function kids_options_general_sections() {
	$tab = kids_get_the_tab();
	
	switch ($tab) {
	case 'general':
		$sections = array();
		
		$sections['general_section'] = esc_attr__('General Options', 'kids');
		
		break;
	case 'bg':
		$sections = array();
		
		$sections['bg_section'] = esc_attr__('Background Options', 'kids');
		
		break;
	case 'header':
		$sections = array();
		
		$sections['header_section'] = esc_attr__('Header Options', 'kids');
		
		break;
	case 'content':
		$sections = array();
		
		$sections['content_section'] = esc_attr__('Content Options', 'kids');
		
		break;
	case 'footer':
		$sections = array();
		
		$sections['footer_section'] = esc_attr__('Footer Options', 'kids');
		
		break;
	}
	
	return $sections;
} 


function kids_options_general_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = kids_get_the_tab();
	}
	
	$options = array();
	
	switch ($tab) {
	case 'general':
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'kids' . '_theme_layout', 
			'title' => esc_html__('Theme Layout', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'liquid', 
			'choices' => array( 
				esc_html__('Liquid', 'kids') . '|liquid', 
				esc_html__('Boxed', 'kids') . '|boxed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'kids' . '_logo_type', 
			'title' => esc_html__('Logo Type', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'image', 
			'choices' => array( 
				esc_html__('Image', 'kids') . '|image', 
				esc_html__('Text', 'kids') . '|text' 
			) 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'kids' . '_logo_url', 
			'title' => esc_html__('Logo Image', 'kids'), 
			'desc' => esc_html__('Choose your website logo image.', 'kids'), 
			'type' => 'upload', 
			'std' => '|' . get_template_directory_uri() . '/img/logo.png', 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'kids' . '_logo_url_retina', 
			'title' => esc_html__('Retina Logo Image', 'kids'), 
			'desc' => esc_html__('Choose logo image for retina displays. Logo for Retina displays should be twice the size of the default one.', 'kids'), 
			'type' => 'upload', 
			'std' => '|' . get_template_directory_uri() . '/img/logo_retina.png', 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'kids' . '_logo_title', 
			'title' => esc_html__('Logo Title', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => ((get_bloginfo('name')) ? get_bloginfo('name') : 'Kids'), 
			'class' => 'nohtml' 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'kids' . '_logo_subtitle', 
			'title' => esc_html__('Logo Subtitle', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => '', 
			'class' => 'nohtml' 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'kids' . '_logo_custom_color', 
			'title' => esc_html__('Custom Text Colors', 'kids'), 
			'desc' => esc_html__('enable', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'kids' . '_logo_title_color', 
			'title' => esc_html__('Logo Title Color', 'kids'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => '' 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'kids' . '_logo_subtitle_color', 
			'title' => esc_html__('Logo Subtitle Color', 'kids'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => '' 
		);
		
		break;
	case 'bg':
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'kids' . '_bg_col', 
			'title' => esc_html__('Background Color', 'kids'), 
			'desc' => '', 
			'type' => 'color', 
			'std' => '#ffffff' 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'kids' . '_bg_img_enable', 
			'title' => esc_html__('Background Image Visibility', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'kids' . '_bg_img', 
			'title' => esc_html__('Background Image', 'kids'), 
			'desc' => esc_html__('Choose your custom website background image url.', 'kids'), 
			'type' => 'upload', 
			'std' => '', 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'kids' . '_bg_rep', 
			'title' => esc_html__('Background Repeat', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'no-repeat', 
			'choices' => array( 
				esc_html__('No Repeat', 'kids') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'kids') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'kids') . '|repeat-y', 
				esc_html__('Repeat', 'kids') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'kids' . '_bg_pos', 
			'title' => esc_html__('Background Position', 'kids'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => 'top center', 
			'choices' => array( 
				esc_html__('Top Left', 'kids') . '|top left', 
				esc_html__('Top Center', 'kids') . '|top center', 
				esc_html__('Top Right', 'kids') . '|top right', 
				esc_html__('Center Left', 'kids') . '|center left', 
				esc_html__('Center Center', 'kids') . '|center center', 
				esc_html__('Center Right', 'kids') . '|center right', 
				esc_html__('Bottom Left', 'kids') . '|bottom left', 
				esc_html__('Bottom Center', 'kids') . '|bottom center', 
				esc_html__('Bottom Right', 'kids') . '|bottom right' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'kids' . '_bg_att', 
			'title' => esc_html__('Background Attachment', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'scroll', 
			'choices' => array( 
				esc_html__('Scroll', 'kids') . '|scroll', 
				esc_html__('Fixed', 'kids') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'kids' . '_bg_size', 
			'title' => esc_html__('Background Size', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'cover', 
			'choices' => array( 
				esc_html__('Auto', 'kids') . '|auto', 
				esc_html__('Cover', 'kids') . '|cover', 
				esc_html__('Contain', 'kids') . '|contain' 
			) 
		);
		
		break;
	case 'header':
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_fixed_header', 
			'title' => esc_html__('Fixed Header', 'kids'), 
			'desc' => esc_html__('enable', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_overlaps', 
			'title' => esc_html__('Header Overlaps Content', 'kids'), 
			'desc' => esc_html__('enable', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_top_line', 
			'title' => esc_html__('Top Line', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_top_height', 
			'title' => esc_html__('Top Height', 'kids'), 
			'desc' => esc_html__('pixels', 'kids'), 
			'type' => 'number', 
			'std' => '34', 
			'min' => '30' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_top_line_short_info', 
			'title' => esc_html__('Top Short Info', 'kids'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'kids') . '</strong>', 
			'type' => 'textarea', 
			'std' => '', 
			'class' => '' 
		);
		
	if (CMSMASTERS_DONATIONS) {
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_top_line_donations_but', 
			'title' => esc_html__('Top Donations Button', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_top_line_donations_but_text', 
			'title' => esc_html__('Top Donations Button Text', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => esc_html__('Donate Now!', 'kids'), 
			'class' => 'nohtml' 
		);
	}
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_top_line_add_cont', 
			'title' => esc_html__('Top Additional Content', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'social', 
			'choices' => array( 
				esc_html__('None', 'kids') . '|none', 
				esc_html__('Top Line Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'kids') . '|social', 
				esc_html__('Top Line Navigation (will be shown if set in Appearance - Menus tab)', 'kids') . '|nav' 
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_styles', 
			'title' => esc_html__('Header Styles', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'default', 
			'choices' => array( 
				esc_html__('Default Style', 'kids') . '|default', 
				esc_html__('Compact Style Left Navigation', 'kids') . '|l_nav', 
				esc_html__('Compact Style Right Navigation', 'kids') . '|r_nav', 
				esc_html__('Compact Style Center Navigation', 'kids') . '|c_nav'
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_mid_height', 
			'title' => esc_html__('Header Middle Height', 'kids'), 
			'desc' => esc_html__('pixels', 'kids'), 
			'type' => 'number', 
			'std' => '100', 
			'min' => '80' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_bot_height', 
			'title' => esc_html__('Header Bottom Height', 'kids'), 
			'desc' => esc_html__('pixels', 'kids'), 
			'type' => 'number', 
			'std' => '50', 
			'min' => '40' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_search', 
			'title' => esc_html__('Header Search', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
	if (CMSMASTERS_DONATIONS) {
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_donations_but', 
			'title' => esc_html__('Header Donations Button', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_donations_but_text', 
			'title' => esc_html__('Header Donations Button Text', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => esc_html__('Donate Now!', 'kids'), 
			'class' => 'nohtml' 
		);
	}
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_add_cont', 
			'title' => esc_html__('Header Additional Content', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'social', 
			'choices' => array( 
				esc_html__('None', 'kids') . '|none', 
				esc_html__('Header Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'kids') . '|social', 
				esc_html__('Header Custom HTML', 'kids') . '|cust_html' 
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'kids' . '_header_add_cont_cust_html', 
			'title' => esc_html__('Header Custom HTML', 'kids'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'kids') . '</strong>', 
			'type' => 'textarea', 
			'std' => '', 
			'class' => '' 
		);
		
		if (CMSMASTERS_WOOCOMMERCE) {
			$options[] = array(
				'section' => 'header_section',
				'id' => 'kids' . '_woocommerce_cart_dropdown',
				'title' => esc_html__('Disable WooCommerce Cart', 'kids'),
				'desc' => '',
				'type' => 'checkbox',
				'std' => 0
			);
		}
		
		break;
	case 'content':
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_layout', 
			'title' => esc_html__('Layout Type by Default', 'kids'), 
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'kids'), 
			'type' => 'radio_img', 
			'std' => 'fullwidth', 
			'choices' => array( 
				esc_html__('Right Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_archives_layout', 
			'title' => esc_html__('Archives Layout Type', 'kids'), 
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Archive Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'kids'), 
			'type' => 'radio_img', 
			'std' => 'fullwidth', 
			'choices' => array( 
				esc_html__('Right Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_search_layout', 
			'title' => esc_html__('Search Layout Type', 'kids'), 
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Search Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'kids'), 
			'type' => 'radio_img', 
			'std' => 'fullwidth', 
			'choices' => array( 
				esc_html__('Right Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
	if (CMSMASTERS_EVENTS_CALENDAR) {
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_events_layout', 
			'title' => esc_html__('Events Calendar Layout Type', 'kids'), 
			'desc' => '', 
			'type' => 'radio_img', 
			'std' => 'fullwidth', 
			'choices' => array( 
				esc_html__('Right Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
	}
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_other_layout', 
			'title' => esc_html__('Other Layout Type', 'kids'), 
			'desc' => esc_html__('Layout for pages of non-listed types. Choosing layout with a sidebar please make sure to add widgets to the Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'kids'), 
			'type' => 'radio_img', 
			'std' => 'fullwidth', 
			'choices' => array( 
				esc_html__('Right Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'kids') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_heading_alignment', 
			'title' => esc_html__('Heading Alignment by Default', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'left', 
			'choices' => array( 
				esc_html__('Left', 'kids') . '|left', 
				esc_html__('Right', 'kids') . '|right', 
				esc_html__('Center', 'kids') . '|center' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_heading_scheme', 
			'title' => esc_html__('Heading Color Scheme by Default', 'kids'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => 'default', 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_heading_bg_image_enable', 
			'title' => esc_html__('Heading Background Image Visibility by Default', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_heading_bg_image', 
			'title' => esc_html__('Heading Background Image by Default', 'kids'), 
			'desc' => esc_html__('Choose your custom heading background image by default.', 'kids'), 
			'type' => 'upload', 
			'std' => '', 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_heading_bg_repeat', 
			'title' => esc_html__('Heading Background Repeat by Default', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'no-repeat', 
			'choices' => array( 
				esc_html__('No Repeat', 'kids') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'kids') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'kids') . '|repeat-y', 
				esc_html__('Repeat', 'kids') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_heading_bg_attachment', 
			'title' => esc_html__('Heading Background Attachment by Default', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'scroll', 
			'choices' => array( 
				esc_html__('Scroll', 'kids') . '|scroll', 
				esc_html__('Fixed', 'kids') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_heading_bg_size', 
			'title' => esc_html__('Heading Background Size by Default', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'cover', 
			'choices' => array( 
				esc_html__('Auto', 'kids') . '|auto', 
				esc_html__('Cover', 'kids') . '|cover', 
				esc_html__('Contain', 'kids') . '|contain' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_heading_bg_color', 
			'title' => esc_html__('Heading Background Color Overlay by Default', 'kids'), 
			'desc' => '',  
			'type' => 'rgba', 
			'std' => '' 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_heading_height', 
			'title' => esc_html__('Heading Height by Default', 'kids'), 
			'desc' => esc_html__('pixels', 'kids'), 
			'type' => 'number', 
			'std' => '80', 
			'min' => '0' 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_breadcrumbs', 
			'title' => esc_html__('Breadcrumbs Visibility by Default', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_bottom_scheme', 
			'title' => esc_html__('Bottom Color Scheme', 'kids'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => 'default', 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_bottom_sidebar', 
			'title' => esc_html__('Bottom Sidebar Visibility by Default', 'kids'), 
			'desc' => esc_html__('show', 'kids') . '<br><br>' . esc_html__('Please make sure to add widgets in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'kids' . '_bottom_sidebar_layout', 
			'title' => esc_html__('Bottom Sidebar Layout by Default', 'kids'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => '14141414', 
			'choices' => array( 
				'1/1|11', 
				'1/2 + 1/2|1212', 
				'1/3 + 2/3|1323', 
				'2/3 + 1/3|2313', 
				'1/4 + 3/4|1434', 
				'3/4 + 1/4|3414', 
				'1/3 + 1/3 + 1/3|131313', 
				'1/2 + 1/4 + 1/4|121414', 
				'1/4 + 1/2 + 1/4|141214', 
				'1/4 + 1/4 + 1/2|141412', 
				'1/4 + 1/4 + 1/4 + 1/4|14141414' 
			) 
		);
		
		break;
	case 'footer':
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'kids' . '_footer_scheme', 
			'title' => esc_html__('Footer Color Scheme', 'kids'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => 'footer', 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'kids' . '_footer_type', 
			'title' => esc_html__('Footer Type', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'default', 
			'choices' => array( 
				esc_html__('Default', 'kids') . '|default', 
				esc_html__('Small', 'kids') . '|small' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'kids' . '_footer_additional_content', 
			'title' => esc_html__('Footer Additional Content', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'social', 
			'choices' => array( 
				esc_html__('None', 'kids') . '|none', 
				esc_html__('Footer Navigation (will be shown if set in Appearance - Menus tab)', 'kids') . '|nav', 
				esc_html__('Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'kids') . '|social', 
				esc_html__('Custom HTML', 'kids') . '|text' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'kids' . '_footer_logo', 
			'title' => esc_html__('Footer Logo', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'kids' . '_footer_logo_url', 
			'title' => esc_html__('Footer Logo', 'kids'), 
			'desc' => esc_html__('Choose your website footer logo image.', 'kids'), 
			'type' => 'upload', 
			'std' => '|' . get_template_directory_uri() . '/img/logo_footer.png', 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'kids' . '_footer_logo_url_retina', 
			'title' => esc_html__('Footer Logo for Retina', 'kids'), 
			'desc' => esc_html__('Choose your website footer logo image for retina.', 'kids'), 
			'type' => 'upload', 
			'std' => '|' . get_template_directory_uri() . '/img/logo_footer_retina.png', 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'kids' . '_footer_nav', 
			'title' => esc_html__('Footer Navigation', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'kids' . '_footer_social', 
			'title' => esc_html__('Footer Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'kids' . '_footer_html', 
			'title' => esc_html__('Footer Custom HTML', 'kids'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'kids') . '</strong>', 
			'type' => 'textarea', 
			'std' => '', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'kids' . '_footer_copyright', 
			'title' => esc_html__('Copyright Text', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => 'Kids' . ' &copy; ' . date('Y') . ' / ' . esc_html__('All Rights Reserved', 'kids'), 
			'class' => '' 
		);
		
		break;
	}
	
	return $options;
}

