<?php 
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version 	1.0.0
 * 
 * Admin Panel Element Options
 * Created by CMSMasters
 * 
 */


function kids_options_element_tabs() {
	$tabs = array();
	
	$tabs['sidebar'] = esc_attr__('Sidebars', 'kids');
	$tabs['icon'] = esc_attr__('Social Icons', 'kids');
	$tabs['lightbox'] = esc_attr__('Lightbox', 'kids');
	$tabs['sitemap'] = esc_attr__('Sitemap', 'kids');
	$tabs['error'] = esc_attr__('404', 'kids');
	$tabs['code'] = esc_attr__('Custom Codes', 'kids');
	
	if (class_exists('Cmsmasters_Form_Builder')) {
		$tabs['recaptcha'] = esc_attr__('reCAPTCHA', 'kids');
	}
	
	return $tabs;
}


function kids_options_element_sections() {
	$tab = kids_get_the_tab();
	
	switch ($tab) {
	case 'sidebar':
		$sections = array();
		
		$sections['sidebar_section'] = esc_attr__('Custom Sidebars', 'kids');
		
		break;
	case 'icon':
		$sections = array();
		
		$sections['icon_section'] = esc_attr__('Social Icons', 'kids');
		
		break;
	case 'lightbox':
		$sections = array();
		
		$sections['lightbox_section'] = esc_attr__('Theme Lightbox Options', 'kids');
		
		break;
	case 'sitemap':
		$sections = array();
		
		$sections['sitemap_section'] = esc_attr__('Sitemap Page Options', 'kids');
		
		break;
	case 'error':
		$sections = array();
		
		$sections['error_section'] = esc_attr__('404 Error Page Options', 'kids');
		
		break;
	case 'code':
		$sections = array();
		
		$sections['code_section'] = esc_attr__('Custom Codes', 'kids');
		
		break;
	case 'recaptcha':
		$sections = array();
		
		$sections['recaptcha_section'] = esc_attr__('Form Builder Plugin reCAPTCHA Keys', 'kids');
		
		break;
	}
	
	return $sections;	
} 


function kids_options_element_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = kids_get_the_tab();
	}
	
	$options = array();
	
	switch ($tab) {
	case 'sidebar':
		$options[] = array( 
			'section' => 'sidebar_section', 
			'id' => 'kids' . '_sidebar', 
			'title' => esc_html__('Custom Sidebars', 'kids'), 
			'desc' => '', 
			'type' => 'sidebar', 
			'std' => '' 
		);
		
		break;
	case 'icon':
		$options[] = array( 
			'section' => 'icon_section', 
			'id' => 'kids' . '_social_icons', 
			'title' => esc_html__('Social Icons', 'kids'), 
			'desc' => '', 
			'type' => 'social', 
			'std' => array( 
				'cmsmasters-icon-twitter|#|' . esc_html__('Twitter', 'kids') . '|true|#edf6f8|#fe677a', 
				'cmsmasters-icon-linkedin|#|' . esc_html__('Linkedin', 'kids') . '|true|#edf6f8|#fe677a', 
				'cmsmasters-icon-google|#|' . esc_html__('Google', 'kids') . '|true|#edf6f8|#fe677a', 
				'cmsmasters-icon-facebook-1|#|' . esc_html__('Facebook', 'kids') . '|true|#edf6f8|#fe677a', 
				'cmsmasters-icon-youtube-play|#|' . esc_html__('YouTube', 'kids') . '|true|#edf6f8|#fe677a' 
			) 
		);
		
		break;
	case 'lightbox':
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_skin', 
			'title' => esc_html__('Skin', 'kids'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => 'dark', 
			'choices' => array( 
				esc_html__('Dark', 'kids') . '|dark', 
				esc_html__('Light', 'kids') . '|light', 
				esc_html__('Mac', 'kids') . '|mac', 
				esc_html__('Metro Black', 'kids') . '|metro-black', 
				esc_html__('Metro White', 'kids') . '|metro-white', 
				esc_html__('Parade', 'kids') . '|parade', 
				esc_html__('Smooth', 'kids') . '|smooth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_path', 
			'title' => esc_html__('Path', 'kids'), 
			'desc' => esc_html__('Sets path for switching windows', 'kids'), 
			'type' => 'radio', 
			'std' => 'vertical', 
			'choices' => array( 
				esc_html__('Vertical', 'kids') . '|vertical', 
				esc_html__('Horizontal', 'kids') . '|horizontal' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_infinite', 
			'title' => esc_html__('Infinite', 'kids'), 
			'desc' => esc_html__('Sets the ability to infinite the group', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_aspect_ratio', 
			'title' => esc_html__('Keep Aspect Ratio', 'kids'), 
			'desc' => esc_html__('Sets the resizing method used to keep aspect ratio within the viewport', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_mobile_optimizer', 
			'title' => esc_html__('Mobile Optimizer', 'kids'), 
			'desc' => esc_html__('Make lightboxes optimized for giving better experience with mobile devices', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_max_scale', 
			'title' => esc_html__('Max Scale', 'kids'), 
			'desc' => esc_html__('Sets the maximum viewport scale of the content', 'kids'), 
			'type' => 'number', 
			'std' => 1, 
			'min' => 0.1, 
			'max' => 2, 
			'step' => 0.05 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_min_scale', 
			'title' => esc_html__('Min Scale', 'kids'), 
			'desc' => esc_html__('Sets the minimum viewport scale of the content', 'kids'), 
			'type' => 'number', 
			'std' => 0.2, 
			'min' => 0.1, 
			'max' => 2, 
			'step' => 0.05 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_inner_toolbar', 
			'title' => esc_html__('Inner Toolbar', 'kids'), 
			'desc' => esc_html__('Bring buttons into windows, or let them be over the overlay', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_smart_recognition', 
			'title' => esc_html__('Smart Recognition', 'kids'), 
			'desc' => esc_html__('Sets content auto recognize from web pages', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_fullscreen_one_slide', 
			'title' => esc_html__('Fullscreen One Slide', 'kids'), 
			'desc' => esc_html__('Decide to fullscreen only one slide or hole gallery the fullscreen mode', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_fullscreen_viewport', 
			'title' => esc_html__('Fullscreen Viewport', 'kids'), 
			'desc' => esc_html__('Sets the resizing method used to fit content within the fullscreen mode', 'kids'), 
			'type' => 'select', 
			'std' => 'center', 
			'choices' => array( 
				esc_html__('Center', 'kids') . '|center', 
				esc_html__('Fit', 'kids') . '|fit', 
				esc_html__('Fill', 'kids') . '|fill', 
				esc_html__('Stretch', 'kids') . '|stretch' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_controls_toolbar', 
			'title' => esc_html__('Toolbar Controls', 'kids'), 
			'desc' => esc_html__('Sets buttons be available or not', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_controls_arrows', 
			'title' => esc_html__('Arrow Controls', 'kids'), 
			'desc' => esc_html__('Enable the arrow buttons', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_controls_fullscreen', 
			'title' => esc_html__('Fullscreen Controls', 'kids'), 
			'desc' => esc_html__('Sets the fullscreen button', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_controls_thumbnail', 
			'title' => esc_html__('Thumbnails Controls', 'kids'), 
			'desc' => esc_html__('Sets the thumbnail navigation', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_controls_keyboard', 
			'title' => esc_html__('Keyboard Controls', 'kids'), 
			'desc' => esc_html__('Sets the keyboard navigation', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_controls_mousewheel', 
			'title' => esc_html__('Mouse Wheel Controls', 'kids'), 
			'desc' => esc_html__('Sets the mousewheel navigation', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_controls_swipe', 
			'title' => esc_html__('Swipe Controls', 'kids'), 
			'desc' => esc_html__('Sets the swipe navigation', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'kids' . '_ilightbox_controls_slideshow', 
			'title' => esc_html__('Slideshow Controls', 'kids'), 
			'desc' => esc_html__('Enable the slideshow feature and button', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		break;
	case 'sitemap':
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'kids' . '_sitemap_nav', 
			'title' => esc_html__('Website Pages', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'kids' . '_sitemap_categs', 
			'title' => esc_html__('Blog Archives by Categories', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'kids' . '_sitemap_tags', 
			'title' => esc_html__('Blog Archives by Tags', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'kids' . '_sitemap_month', 
			'title' => esc_html__('Blog Archives by Month', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'kids' . '_sitemap_pj_categs', 
			'title' => esc_html__('Portfolio Archives by Categories', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'kids' . '_sitemap_pj_tags', 
			'title' => esc_html__('Portfolio Archives by Tags', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		break;
	case 'error':
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_color', 
			'title' => esc_html__('Text Color', 'kids'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => '#ffffff' 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_bg_color', 
			'title' => esc_html__('Background Color', 'kids'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => '#F96C7E' 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_bg_img_enable', 
			'title' => esc_html__('Background Image Visibility', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_bg_image', 
			'title' => esc_html__('Background Image', 'kids'), 
			'desc' => esc_html__('Choose your custom error page background image.', 'kids'), 
			'type' => 'upload', 
			'std' => '', 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_bg_rep', 
			'title' => esc_html__('Background Repeat', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'no-repeat', 
			'choices' => array( 
				esc_html__('No Repeat', 'kids') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'kids') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'kids') . '|repeat-y', 
				esc_html__('Repeat', 'kids') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_bg_pos', 
			'title' => esc_html__('Background Position', 'kids'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => 'top center', 
			'choices' => array( 
				esc_html__('Top Left', 'kids') . '|top left', 
				esc_html__('Top Center', 'kids') . '|top center', 
				esc_html__('Top Right', 'kids') . '|top right', 
				esc_html__('Center Left', 'kids') . '|center left', 
				esc_html__('Center Center', 'kids') . '|center center', 
				esc_html__('Center Right', 'kids') . '|center right', 
				esc_html__('Bottom Left', 'kids') . '|bottom left', 
				esc_html__('Bottom Center', 'kids') . '|bottom center', 
				esc_html__('Bottom Right', 'kids') . '|bottom right' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_bg_att', 
			'title' => esc_html__('Background Attachment', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'scroll', 
			'choices' => array( 
				esc_html__('Scroll', 'kids') . '|scroll', 
				esc_html__('Fixed', 'kids') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_bg_size', 
			'title' => esc_html__('Background Size', 'kids'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'cover', 
			'choices' => array( 
				esc_html__('Auto', 'kids') . '|auto', 
				esc_html__('Cover', 'kids') . '|cover', 
				esc_html__('Contain', 'kids') . '|contain' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_search', 
			'title' => esc_html__('Search Line', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_sitemap_button', 
			'title' => esc_html__('Sitemap Button', 'kids'), 
			'desc' => esc_html__('show', 'kids'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'kids' . '_error_sitemap_link', 
			'title' => esc_html__('Sitemap Page URL', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => '', 
			'class' => '' 
		);
		
		break;
	case 'code':
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'kids' . '_custom_css', 
			'title' => esc_html__('Custom CSS', 'kids'), 
			'desc' => '', 
			'type' => 'textarea', 
			'std' => '', 
			'class' => 'allowlinebreaks' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'kids' . '_custom_js', 
			'title' => esc_html__('Custom JavaScript', 'kids'), 
			'desc' => '', 
			'type' => 'textarea', 
			'std' => '', 
			'class' => 'allowlinebreaks' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'kids' . '_gmap_api_key', 
			'title' => esc_html__('Google Maps API key', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => '', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'kids' . '_api_key', 
			'title' => esc_html__('Twitter API key', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => '', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'kids' . '_api_secret', 
			'title' => esc_html__('Twitter API secret', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => '', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'kids' . '_access_token', 
			'title' => esc_html__('Twitter Access token', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => '', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'kids' . '_access_token_secret', 
			'title' => esc_html__('Twitter Access token secret', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => '', 
			'class' => '' 
		);
		
		break;
	case 'recaptcha':
		$options[] = array( 
			'section' => 'recaptcha_section', 
			'id' => 'kids' . '_recaptcha_public_key', 
			'title' => esc_html__('reCAPTCHA Public Key', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => '', 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'recaptcha_section', 
			'id' => 'kids' . '_recaptcha_private_key', 
			'title' => esc_html__('reCAPTCHA Private Key', 'kids'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => '', 
			'class' => '' 
		);
		
		break;
	}
	
	return $options;	
}

