<?php 
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version		1.0.0
 * 
 * Admin Panel Theme Settings Import/Export
 * Created by CMSMasters
 * 
 */


function kids_options_demo_tabs() {
	$tabs = array();
	
	
	$tabs['import'] = esc_attr__('Import', 'kids');
	$tabs['export'] = esc_attr__('Export', 'kids');
	
	
	return $tabs;
}


function kids_options_demo_sections() {
	$tab = kids_get_the_tab();
	
	
	switch ($tab) {
	case 'import':
		$sections = array();
		
		$sections['import_section'] = esc_html__('Theme Settings Import', 'kids');
		
		
		break;
	case 'export':
		$sections = array();
		
		$sections['export_section'] = esc_html__('Theme Settings Export', 'kids');
		
		
		break;
	}
	
	
	return $sections;
} 


function kids_options_demo_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = kids_get_the_tab();
	}
	
	
	$options = array();
	
	
	switch ($tab) {
	case 'import':
		$options[] = array( 
			'section' => 'import_section', 
			'id' => 'kids' . '_demo_import', 
			'title' => esc_html__('Theme Settings', 'kids'), 
			'desc' => esc_html__("Enter your theme settings data here and click 'Import' button", 'kids'), 
			'type' => 'textarea', 
			'std' => '', 
			'class' => '' 
		);
		
		
		break;
	case 'export':
		$options[] = array( 
			'section' => 'export_section', 
			'id' => 'kids' . '_demo_export', 
			'title' => esc_html__('Theme Settings', 'kids'), 
			'desc' => esc_html__("Click here to export your theme settings data to the file", 'kids'), 
			'type' => 'button', 
			'std' => esc_html__('Export Theme Settings', 'kids'), 
			'class' => 'cmsmasters-demo-export' 
		);
		
		
		break;
	}
	
	
	return $options;	
}

