<?php
/**
 * @package 	WordPress
 * @subpackage 	Kids
 * @version 	1.1.4
 * 
 * Content Composer Sc Name Shortcode
 * Created by CMSMasters
 * 
 */

/* 
	1. Create a separate file for each of the shortcodes that need to be edited. 
	2. Contents of this file will be used to substitute the corresponding code in the shortcodes.php file of the Composer Plugin.
	3. $out variable must contain all the shortcode front-end content
*/


extract(shortcode_atts($new_atts, $atts));


$this->toggles_atts['toggle_counter']++;

$unique_id = uniqid();

$toggle_tags = explode(',', $tags);


foreach ($toggle_tags as $toggle_tag) {
	if ($toggle_tag != '') {
		$this->toggles_atts['sort_toggles'][generateSlug(trim($toggle_tag), 30)] = trim($toggle_tag);
	}
}


$out = '<div id="cmsmasters_toggle_' . $unique_id . '" class="cmsmasters_toggle_wrap' . 
(($this->toggles_atts['toggle_active'] == $this->toggles_atts['toggle_counter']) ? ' current_toggle' : '') . 
(($classes != '') ? ' ' . $classes : '') . 
'" data-tags="all ';


$tgl_tag_str = '';


foreach ($toggle_tags as $tgl_tag) {
	$tgl_tag_str .= generateSlug(trim($tgl_tag), 30) . ' ';
}


$out .= substr($tgl_tag_str, 0, strlen($tgl_tag_str) - 1);


if ($color !== '') {
	$out .= "<style type=\"text/css\">
		.toggles_mode_accordion #cmsmasters_toggle_{$unique_id} .cmsmasters_toggle_title:hover .cmsmasters_toggle_plus, 
		.toggles_mode_toggle #cmsmasters_toggle_{$unique_id} {
			" . cmsmasters_color_css('background-color', $color) . "
		}
		
		.toggles_mode_accordion #cmsmasters_toggle_{$unique_id} .cmsmasters_toggle_title a:hover {
			" . cmsmasters_color_css('color', $color) . "
		}
	</style>";
}

$out .= '">' . "\n" . 
	'<div class="cmsmasters_toggle_title">' . "\n" . 
		'<span class="cmsmasters_toggle_plus">' . "\n" . 
			'<span class="cmsmasters_toggle_plus_hor"></span>' . "\n" . 
			'<span class="cmsmasters_toggle_plus_vert"></span>' . "\n" . 
		'</span>' . "\n" . 
		'<a href="#">' . $title . '</a>' . "\n" . 
	'</div>' . "\n" . 
	'<div class="cmsmasters_toggle">' . "\n" . 
		cmsmasters_divpdel('<div class="cmsmasters_toggle_inner">' . "\n" . 
			do_shortcode(wpautop($content)) . 
		'</div>' . "\n") . 
	'</div>' . "\n" . 
'</div>';


echo kids_return_content($out);
